/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.datastructures.heap;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.utilities.datastructures.heap.DoubleIntegerHeap;
import de.lmu.ifi.dbs.elki.utilities.datastructures.iterator.Iter;
import java.util.Arrays;

public class DoubleIntegerMinHeap
implements DoubleIntegerHeap {
    protected double[] twoheap;
    protected int[] twovals;
    protected int size;
    private static final int TWO_HEAP_INITIAL_SIZE = 31;

    public DoubleIntegerMinHeap() {
        double[] dArray = new double[31];
        int[] nArray = new int[31];
        this.twoheap = dArray;
        this.twovals = nArray;
    }

    public DoubleIntegerMinHeap(int n) {
        int n2 = MathUtil.nextPow2Int(n + 1) - 1;
        double[] dArray = new double[n2];
        int[] nArray = new int[n2];
        this.twoheap = dArray;
        this.twovals = nArray;
    }

    @Override
    public void clear() {
        this.size = 0;
        Arrays.fill(this.twoheap, 0.0);
        Arrays.fill(this.twovals, 0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void add(double d, int n) {
        double d2 = d;
        int n2 = n;
        if (this.size >= this.twoheap.length) {
            this.twoheap = Arrays.copyOf(this.twoheap, this.twoheap.length + this.twoheap.length + 1);
            this.twovals = Arrays.copyOf(this.twovals, this.twovals.length + this.twovals.length + 1);
        }
        int n3 = this.size++;
        this.twoheap[n3] = d2;
        this.twovals[n3] = n2;
        this.heapifyUp(n3, d2, n2);
    }

    @Override
    public void add(double d, int n, int n2) {
        if (this.size < n2) {
            this.add(d, n);
        } else if (this.twoheap[0] < d) {
            this.replaceTopElement(d, n);
        }
    }

    @Override
    public void replaceTopElement(double d, int n) {
        this.heapifyDown(d, n);
    }

    private void heapifyUp(int n, double d, int n2) {
        int n3;
        double d2;
        while (n > 0 && !(d >= (d2 = this.twoheap[n3 = n - 1 >>> 1]))) {
            this.twoheap[n] = d2;
            this.twovals[n] = this.twovals[n3];
            n = n3;
        }
        this.twoheap[n] = d;
        this.twovals[n] = n2;
    }

    @Override
    public void poll() {
        --this.size;
        if (this.size > 0) {
            double d = this.twoheap[this.size];
            int n = this.twovals[this.size];
            this.twoheap[this.size] = 0.0;
            this.twovals[this.size] = 0;
            this.heapifyDown(d, n);
        } else {
            this.twoheap[0] = 0.0;
            this.twovals[0] = 0;
        }
    }

    private void heapifyDown(double d, int n) {
        int n2 = this.size >>> 1;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = (n3 << 1) + 1;
            double d2 = this.twoheap[n4];
            int n5 = n4 + 1;
            if (n5 < this.size && d2 > this.twoheap[n5]) {
                n4 = n5;
                d2 = this.twoheap[n5];
            }
            if (d <= d2) break;
            this.twoheap[n3] = d2;
            this.twovals[n3] = this.twovals[n4];
            n3 = n4;
        }
        this.twoheap[n3] = d;
        this.twovals[n3] = n;
    }

    @Override
    public double peekKey() {
        return this.twoheap[0];
    }

    @Override
    public int peekValue() {
        return this.twovals[0];
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(DoubleIntegerMinHeap.class.getSimpleName()).append(" [");
        UnsortedIter unsortedIter = new UnsortedIter();
        while (unsortedIter.valid()) {
            stringBuilder.append(unsortedIter.getKey()).append(':').append(unsortedIter.getValue()).append(',');
            unsortedIter.advance();
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public UnsortedIter unsortedIter() {
        return new UnsortedIter();
    }

    private class UnsortedIter
    implements DoubleIntegerHeap.UnsortedIter {
        protected int pos = 0;

        private UnsortedIter() {
        }

        @Override
        public boolean valid() {
            return this.pos < DoubleIntegerMinHeap.this.size;
        }

        @Override
        public Iter advance() {
            ++this.pos;
            return this;
        }

        @Override
        public double getKey() {
            return DoubleIntegerMinHeap.this.twoheap[this.pos];
        }

        @Override
        public int getValue() {
            return DoubleIntegerMinHeap.this.twovals[this.pos];
        }
    }
}

