/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.scaling.outlier;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.Mean;
import de.lmu.ifi.dbs.elki.math.MeanVariance;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.NormalDistribution;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.utilities.datastructures.arraylike.NumberArrayAdapter;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import de.lmu.ifi.dbs.elki.utilities.scaling.outlier.OutlierScalingFunction;

@Reference(authors="H.-P. Kriegel, P. Kr\u00f6ger, E. Schubert, A. Zimek", title="Interpreting and Unifying Outlier Scores", booktitle="Proc. 11th SIAM International Conference on Data Mining (SDM), Mesa, AZ, 2011", url="http://dx.doi.org/10.1137/1.9781611972818.2")
public class StandardDeviationScaling
implements OutlierScalingFunction {
    protected Double fixedmean = null;
    protected double lambda;
    double mean;
    double factor;

    public StandardDeviationScaling(Double d, double d2) {
        this.fixedmean = d;
        this.lambda = d2;
    }

    public StandardDeviationScaling() {
        this(null, 1.0);
    }

    @Override
    public double getScaled(double d) {
        assert (this.factor != 0.0) : "prepare() was not run prior to using the scaling function.";
        if (d <= this.mean) {
            return 0.0;
        }
        return Math.max(0.0, NormalDistribution.erf((d - this.mean) / this.factor));
    }

    @Override
    public void prepare(OutlierResult outlierResult) {
        if (this.fixedmean == null) {
            MeanVariance meanVariance = new MeanVariance();
            DoubleRelation doubleRelation = outlierResult.getScores();
            DBIDIter dBIDIter = doubleRelation.iterDBIDs();
            while (dBIDIter.valid()) {
                double d = doubleRelation.doubleValue(dBIDIter);
                if (!Double.isNaN(d) && !Double.isInfinite(d)) {
                    meanVariance.put(d);
                }
                dBIDIter.advance();
            }
            this.mean = meanVariance.getMean();
            this.factor = this.lambda * meanVariance.getSampleStddev() * MathUtil.SQRT2;
            if (this.factor == 0.0) {
                this.factor = Double.MIN_NORMAL;
            }
        } else {
            this.mean = this.fixedmean;
            Mean mean = new Mean();
            DoubleRelation doubleRelation = outlierResult.getScores();
            DBIDIter dBIDIter = doubleRelation.iterDBIDs();
            while (dBIDIter.valid()) {
                double d = doubleRelation.doubleValue(dBIDIter);
                if (!Double.isNaN(d) && !Double.isInfinite(d)) {
                    mean.put((d - this.mean) * (d - this.mean));
                }
                dBIDIter.advance();
            }
            this.factor = this.lambda * Math.sqrt(mean.getMean()) * MathUtil.SQRT2;
            if (this.factor == 0.0) {
                this.factor = Double.MIN_NORMAL;
            }
        }
    }

    @Override
    public <A> void prepare(A a, NumberArrayAdapter<?, A> numberArrayAdapter) {
        if (this.fixedmean == null) {
            MeanVariance meanVariance = new MeanVariance();
            int n = numberArrayAdapter.size(a);
            for (int i = 0; i < n; ++i) {
                double d = numberArrayAdapter.getDouble(a, i);
                if (Double.isInfinite(d)) continue;
                meanVariance.put(d);
            }
            this.mean = meanVariance.getMean();
            this.factor = this.lambda * meanVariance.getSampleStddev() * MathUtil.SQRT2;
            if (this.factor == 0.0) {
                this.factor = Double.MIN_NORMAL;
            }
        } else {
            this.mean = this.fixedmean;
            Mean mean = new Mean();
            int n = numberArrayAdapter.size(a);
            for (int i = 0; i < n; ++i) {
                double d = numberArrayAdapter.getDouble(a, i);
                if (Double.isInfinite(d)) continue;
                mean.put((d - this.mean) * (d - this.mean));
            }
            this.factor = this.lambda * Math.sqrt(mean.getMean()) * MathUtil.SQRT2;
            if (this.factor == 0.0) {
                this.factor = Double.MIN_NORMAL;
            }
        }
    }

    @Override
    public double getMin() {
        return 0.0;
    }

    @Override
    public double getMax() {
        return 1.0;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID MEAN_ID = new OptionID("stddevscale.mean", "Fixed mean to use in standard deviation scaling.");
        public static final OptionID LAMBDA_ID = new OptionID("stddevscale.lambda", "Significance level to use for error function.");
        protected Double fixedmean = null;
        protected double lambda;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = new DoubleParameter(MEAN_ID);
            doubleParameter2.setOptional(true);
            if (parameterization.grab(doubleParameter2)) {
                this.fixedmean = (Double)doubleParameter2.getValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(LAMBDA_ID, 3.0))) {
                this.lambda = (Double)doubleParameter.getValue();
            }
        }

        @Override
        protected StandardDeviationScaling makeInstance() {
            return new StandardDeviationScaling(this.fixedmean, this.lambda);
        }
    }
}

