/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.gui.detail;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.Result;
import de.lmu.ifi.dbs.elki.result.ResultListener;
import de.lmu.ifi.dbs.elki.visualization.VisualizationItem;
import de.lmu.ifi.dbs.elki.visualization.VisualizationListener;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.gui.overview.PlotItem;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGEffects;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DetailView
extends VisualizationPlot
implements ResultListener,
VisualizationListener {
    private static final Logging LOG = Logging.getLogger(DetailView.class);
    private PlotItem item;
    double ratio = 1.0;
    VisualizerContext context;
    Map<VisualizationTask, Visualization> taskmap = new HashMap<VisualizationTask, Visualization>();
    Map<Visualization, Element> layermap = new HashMap<Visualization, Element>();
    private double width;
    private double height;
    AtomicReference<Runnable> pendingRefresh = new AtomicReference<Object>(null);

    public DetailView(VisualizerContext visualizerContext, PlotItem plotItem, double d) {
        this.context = visualizerContext;
        this.item = new PlotItem(plotItem);
        this.ratio = d;
        this.item.sort();
        this.setDisableInteractions(true);
        this.addBackground(visualizerContext);
        SVGEffects.addShadowFilter(this);
        SVGEffects.addLightGradient(this);
        this.initialize();
        visualizerContext.addVisualizationListener(this);
        visualizerContext.addResultListener(this);
    }

    private void addBackground(VisualizerContext visualizerContext) {
        CSSClass cSSClass = new CSSClass(this, "background");
        cSSClass.setStatement("fill", visualizerContext.getStyleLibrary().getBackgroundColor("page"));
        Element element = this.svgElement("rect");
        SVGUtil.setAtt(element, "x", "0");
        SVGUtil.setAtt(element, "y", "0");
        SVGUtil.setAtt(element, "width", "100%");
        SVGUtil.setAtt(element, "height", "100%");
        SVGUtil.setAtt(element, "noexport", "noexport");
        this.addCSSClassOrLogError(cSSClass);
        SVGUtil.setCSSClass(element, cSSClass.getName());
        this.getRoot().appendChild(element);
    }

    private void initialize() {
        this.width = Math.sqrt(this.getRatio());
        this.height = 1.0 / this.width;
        ArrayList<Visualization> arrayList = new ArrayList<Visualization>();
        for (VisualizationTask object : this.item.tasks) {
            Visualization visualization;
            if (!object.visible || (visualization = this.instantiateVisualization(object)) == null) continue;
            arrayList.add(visualization);
            this.taskmap.put(object, visualization);
            this.layermap.put(visualization, visualization.getLayer());
        }
        for (Visualization visualization : arrayList) {
            if (visualization.getLayer() != null) {
                this.getRoot().appendChild(visualization.getLayer());
                continue;
            }
            LOG.warning("NULL layer seen.");
        }
        double d = this.width / this.height;
        this.getRoot().setAttribute("width", "20cm");
        this.getRoot().setAttribute("height", 20.0 / d + "cm");
        this.getRoot().setAttribute("viewBox", "0 0 " + this.width + " " + this.height);
        this.updateStyleElement();
    }

    private synchronized void refresh() {
        this.pendingRefresh.set(null);
        if (LOG.isDebuggingFine()) {
            LOG.debugFine("Refresh in thread " + Thread.currentThread().getName());
        }
        boolean bl = false;
        for (Map.Entry<VisualizationTask, Visualization> entry : this.taskmap.entrySet()) {
            Element element;
            Element element2;
            VisualizationTask visualizationTask = entry.getKey();
            Visualization visualization = entry.getValue();
            if (visualization == null) {
                visualization = this.instantiateVisualization(visualizationTask);
                entry.setValue(visualization);
            }
            if ((element2 = this.layermap.get(visualization)) == (element = visualization.getLayer())) {
                boolean bl2 = !"hidden".equals(element.getAttribute("visibility"));
                if (visualizationTask.visible == bl2) continue;
                element.setAttribute("visibility", visualizationTask.visible ? "visible" : "hidden");
                continue;
            }
            if (visualizationTask.hasAnyFlags(4)) {
                element.setAttribute("noexport", "noexport");
            }
            if (element2 == null) {
                if (LOG.isDebuggingFine()) {
                    LOG.debugFine("New layer: " + visualizationTask);
                }
                this.getRoot().appendChild(element);
            } else {
                Node node;
                if (LOG.isDebuggingFine()) {
                    LOG.debugFine("Updated layer: " + visualizationTask);
                }
                if ((node = element2.getParentNode()) != null) {
                    node.replaceChild(element, element2);
                }
            }
            this.layermap.put(visualization, element);
            bl = true;
        }
        if (bl) {
            this.updateStyleElement();
        }
    }

    private Visualization instantiateVisualization(VisualizationTask visualizationTask) {
        try {
            Visualization visualization = visualizationTask.getFactory().makeVisualization(visualizationTask, this, this.width, this.height, this.item.proj);
            if (visualizationTask.hasAnyFlags(4)) {
                visualization.getLayer().setAttribute("noexport", "noexport");
            }
            return visualization;
        }
        catch (Exception exception) {
            if (LOG.isDebugging()) {
                LOG.warning("Visualizer " + visualizationTask.getFactory().getClass().getName() + " failed.", exception);
            } else {
                LOG.warning("Visualizer " + visualizationTask.getFactory().getClass().getName() + " failed - enable debugging to see details: " + exception.toString());
            }
            return null;
        }
    }

    public void destroy() {
        this.context.removeVisualizationListener(this);
        this.context.removeResultListener(this);
        for (Map.Entry<VisualizationTask, Visualization> entry : this.taskmap.entrySet()) {
            Visualization visualization = entry.getValue();
            if (visualization == null) continue;
            visualization.destroy();
        }
        this.taskmap.clear();
    }

    @Override
    public void dispose() {
        this.destroy();
        super.dispose();
    }

    public double getRatio() {
        return this.ratio;
    }

    public void setRatio(double d) {
        this.ratio = d;
    }

    private void lazyRefresh() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (DetailView.this.pendingRefresh.compareAndSet(this, null)) {
                    DetailView.this.refresh();
                }
            }
        };
        this.pendingRefresh.set(runnable);
        this.scheduleUpdate(runnable);
    }

    @Override
    public void resultAdded(Result result, Result result2) {
        this.lazyRefresh();
    }

    @Override
    public void resultChanged(Result result) {
        this.lazyRefresh();
    }

    @Override
    public void resultRemoved(Result result, Result result2) {
        this.lazyRefresh();
    }

    @Override
    public void visualizationChanged(VisualizationItem visualizationItem) {
        Object object;
        if (!(visualizationItem instanceof VisualizationTask)) {
            return;
        }
        VisualizationTask visualizationTask = (VisualizationTask)visualizationItem;
        Visualization visualization = this.taskmap.get(visualizationTask);
        if (visualization == null) {
            boolean bl = false;
            object = this.context.getVisHierarchy().iterAncestors(visualizationItem);
            while (object.valid()) {
                if (this.item.proj != null && this.item.proj.getProjector() == object.get() || this.taskmap.containsKey(object.get())) {
                    bl = true;
                    break;
                }
                object.advance();
            }
            if (!bl) {
                return;
            }
        }
        if (visualization == null) {
            this.taskmap.put(visualizationTask, null);
            this.lazyRefresh();
        } else {
            Element element = this.layermap.get(visualization);
            if (element != (object = visualization.getLayer())) {
                this.lazyRefresh();
            } else {
                boolean bl;
                boolean bl2 = bl = !"hidden".equals(object.getAttribute("visibility"));
                if (visualizationTask.visible != bl) {
                    this.lazyRefresh();
                }
            }
        }
    }

    @Override
    protected void redraw() {
        boolean bl = false;
        while (!this.updateQueue.isEmpty()) {
            Visualization visualization = (Visualization)this.updateQueue.pop();
            if (!bl) {
                boolean bl2;
                Element element = this.layermap.get(visualization);
                visualization.incrementalRedraw();
                boolean bl3 = bl2 = element != visualization.getLayer();
                if (LOG.isDebuggingFine() && bl2) {
                    LOG.debugFine("Visualization " + visualization + " changed.");
                }
                bl |= bl2;
                continue;
            }
            visualization.incrementalRedraw();
        }
        if (!bl) {
            // empty if block
        }
        this.refresh();
    }

    public PlotItem getPlotItem() {
        return this.item;
    }
}

