/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.visualization.svg.SVGEffects;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.Event;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class SVGCheckbox {
    protected boolean checked;
    protected EventListenerList listenerList = new EventListenerList();
    protected String label = null;

    public SVGCheckbox(boolean bl) {
        this(bl, null);
    }

    public SVGCheckbox(boolean bl, String string) {
        this.checked = bl;
        this.label = string;
    }

    public Element renderCheckBox(SVGPlot sVGPlot, double d, double d2, double d3) {
        Object object;
        final Element element = SVGEffects.makeCheckmark(sVGPlot);
        element.setAttribute("transform", "scale(" + d3 / 11.0 + ") translate(" + d + " " + d2 + ")");
        if (!this.checked) {
            element.setAttribute("style", "display:none");
        }
        Element element2 = SVGUtil.svgRect(sVGPlot.getDocument(), d, d2, d3, d3);
        element2.setAttribute("fill", "#d4e4f1");
        element2.setAttribute("stroke", "#a0a0a0");
        element2.setAttribute("stroke-width", "0.5");
        Element element3 = sVGPlot.svgElement("g");
        element3.appendChild(element2);
        element3.appendChild(element);
        if (this.label != null) {
            object = sVGPlot.svgText(d + 2.0 * d3, d2 + d3, this.label);
            element3.appendChild((Node)object);
        }
        object = (EventTarget)((Object)element3);
        object.addEventListener("click", new EventListener(){

            protected void check() {
                element.removeAttribute("style");
                SVGCheckbox.this.checked = true;
                SVGCheckbox.this.fireSwitchEvent(new ChangeEvent(SVGCheckbox.this));
            }

            protected void uncheck() {
                element.setAttribute("style", "display:none");
                SVGCheckbox.this.checked = false;
                SVGCheckbox.this.fireSwitchEvent(new ChangeEvent(SVGCheckbox.this));
            }

            @Override
            public void handleEvent(Event event) {
                if (SVGCheckbox.this.checked) {
                    this.uncheck();
                } else {
                    this.check();
                }
            }
        }, false);
        return element3;
    }

    public void addCheckBoxListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeCheckBoxListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public boolean isChecked() {
        return this.checked;
    }

    protected void fireSwitchEvent(ChangeEvent changeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = 0; i < objectArray.length; i += 2) {
            if (objectArray[i] != ChangeListener.class) continue;
            ((ChangeListener)objectArray[i + 1]).stateChanged(changeEvent);
        }
    }
}

