/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.svg;

import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import org.w3c.dom.Element;

public class SVGEffects {
    public static final String SHADOW_ID = "shadow-effect";
    public static final String LIGHT_GRADIENT_ID = "light-gradient";
    public static final String SVG_CHECKMARK_PATH = "M0 6.458 L2.047 4.426 5.442 7.721 12.795 0 15 2.117 5.66 11.922 Z";

    public static void addShadowFilter(SVGPlot sVGPlot) {
        Element element = sVGPlot.getIdElement(SHADOW_ID);
        if (element == null) {
            element = sVGPlot.svgElement("filter");
            element.setAttribute("id", SHADOW_ID);
            element.setAttribute("width", "140%");
            element.setAttribute("height", "140%");
            Element element2 = sVGPlot.svgElement("feOffset");
            element2.setAttribute("in", "SourceAlpha");
            element2.setAttribute("result", "off");
            element2.setAttribute("dx", "0.1");
            element2.setAttribute("dy", "0.1");
            element.appendChild(element2);
            Element element3 = sVGPlot.svgElement("feGaussianBlur");
            element3.setAttribute("in", "off");
            element3.setAttribute("result", "blur");
            element3.setAttribute("stdDeviation", "0.1");
            element.appendChild(element3);
            Element element4 = sVGPlot.svgElement("feBlend");
            element4.setAttribute("in", "SourceGraphic");
            element4.setAttribute("in2", "blur");
            element4.setAttribute("mode", "normal");
            element.appendChild(element4);
            sVGPlot.getDefs().appendChild(element);
            sVGPlot.putIdElement(SHADOW_ID, element);
        }
    }

    public static void addLightGradient(SVGPlot sVGPlot) {
        Element element = sVGPlot.getIdElement(LIGHT_GRADIENT_ID);
        if (element == null) {
            element = sVGPlot.svgElement("linearGradient");
            element.setAttribute("id", LIGHT_GRADIENT_ID);
            element.setAttribute("x1", "0");
            element.setAttribute("y1", "0");
            element.setAttribute("x2", "0");
            element.setAttribute("y2", "1");
            Element element2 = sVGPlot.svgElement("stop");
            element2.setAttribute("stop-color", "white");
            element2.setAttribute("stop-opacity", "1");
            element2.setAttribute("offset", "0");
            element.appendChild(element2);
            Element element3 = sVGPlot.svgElement("stop");
            element3.setAttribute("stop-color", "white");
            element3.setAttribute("stop-opacity", "0");
            element3.setAttribute("offset", ".4");
            element.appendChild(element3);
            Element element4 = sVGPlot.svgElement("stop");
            element4.setAttribute("stop-color", "black");
            element4.setAttribute("stop-opacity", "0");
            element4.setAttribute("offset", ".6");
            element.appendChild(element4);
            Element element5 = sVGPlot.svgElement("stop");
            element5.setAttribute("stop-color", "black");
            element5.setAttribute("stop-opacity", ".5");
            element5.setAttribute("offset", "1");
            element.appendChild(element5);
            sVGPlot.getDefs().appendChild(element);
            sVGPlot.putIdElement(LIGHT_GRADIENT_ID, element);
        }
    }

    public static Element makeCheckmark(SVGPlot sVGPlot) {
        Element element = sVGPlot.svgElement("path");
        element.setAttribute("d", SVG_CHECKMARK_PATH);
        element.setAttribute("fill", "black");
        element.setAttribute("stroke", "none");
        return element;
    }
}

