/*
 * Decompiled with CFR 0.152.
 */
package org.jgap;

import java.io.Serializable;
import junitx.util.PrivateAccessor;
import org.jgap.BaseGene;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.DefaultFitnessEvaluator;
import org.jgap.Gene;
import org.jgap.InvalidConfigurationException;
import org.jgap.RandomGenerator;
import org.jgap.event.EventManager;
import org.jgap.impl.BestChromosomesSelector;
import org.jgap.impl.BooleanGene;
import org.jgap.impl.DefaultMutationRateCalculator;
import org.jgap.impl.IntegerGene;
import org.jgap.impl.MutationOperator;
import org.jgap.impl.StaticFitnessFunction;
import org.jgap.impl.StockRandomGenerator;
import org.jgap.impl.StringGene;

public class ConfigurationForTesting
extends Configuration {
    private static final String CVS_REVISION = "$Revision: 1.2 $";
    public static final double STATIC_FITNESS_VALUE = 2.3;

    public ConfigurationForTesting() throws InvalidConfigurationException {
        this.setPopulationSize(5);
        ConfigurationForTesting.reset();
        this.setFitnessFunction(new StaticFitnessFunction(2.3));
        this.setEventManager(new EventManager());
        this.setFitnessEvaluator(new DefaultFitnessEvaluator());
        this.addNaturalSelector(new BestChromosomesSelector(this), true);
        this.addGeneticOperator(new MutationOperator((Configuration)this, new DefaultMutationRateCalculator(this)));
        this.setRandomGenerator(new StockRandomGenerator());
        Gene[] genes = new Gene[3];
        BaseGene gene = new BooleanGene(this);
        genes[0] = gene;
        gene = new StringGene(this, 1, 10, "abcdefghijklmnopqrstuvwxyz");
        genes[1] = gene;
        MyAppData appData = new MyAppData("TEST123");
        gene.setApplicationData(appData);
        gene = new IntegerGene(this, 100, 300);
        genes[2] = gene;
        Chromosome chrom = new Chromosome((Configuration)this, genes);
        this.setSampleChromosome(chrom);
    }

    public synchronized void setRandomGenerator(RandomGenerator a_generatorToSet) throws InvalidConfigurationException {
        try {
            PrivateAccessor.setField((Object)this, (String)"m_randomGenerator", (Object)a_generatorToSet);
        }
        catch (NoSuchFieldException nex) {
            throw new InvalidConfigurationException(nex.getMessage());
        }
    }

    public class MyAppData
    implements Cloneable,
    Serializable {
        private String m_value;

        public MyAppData(String a_value) {
            this.m_value = a_value;
        }

        public String getValue() {
            return this.m_value;
        }

        public int compareTo(Object a_o) {
            MyAppData other = (MyAppData)a_o;
            return this.m_value.compareTo(other.m_value);
        }

        public Object clone() {
            return new String(this.m_value);
        }
    }
}

