/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.impl.fitness;

import java.util.ArrayList;
import java.util.List;
import org.jgap.BulkFitnessFunction;
import org.jgap.Chromosome;
import org.jgap.Configuration;
import org.jgap.IChromosome;
import org.jgap.Population;

public class RosenbrocksBulkNegativeFunction
extends BulkFitnessFunction {
    Configuration config1;
    List<IChromosome> allChromosomesSoFar;
    int numOfDublicates;
    int numOfUniques;

    RosenbrocksBulkNegativeFunction(Configuration config) {
        this.config1 = config;
        this.allChromosomesSoFar = new ArrayList<IChromosome>();
        this.numOfDublicates = 0;
        this.numOfUniques = 0;
    }

    public double evaluate(IChromosome ic) {
        double X = (Double)ic.getGene(0).getAllele();
        double Y = (Double)ic.getGene(1).getAllele();
        double function = this.getFunctionValue(X, Y);
        return function;
    }

    public double getFunctionValue(double X, double Y) {
        return 100.0 * ((Y - X * X) * (Y - X * X)) + (1.0 - X) * (1.0 - X);
    }

    public void evaluate(Population a_subject) {
        for (IChromosome a_chrom1 : a_subject.getChromosomes()) {
            double res = this.evaluate(a_chrom1);
            ((Chromosome)a_chrom1).setFitnessValueDirectly(res);
            if (this.allChromosomesSoFar.contains((Chromosome)a_chrom1)) {
                ++this.numOfDublicates;
                continue;
            }
            this.allChromosomesSoFar.add(a_chrom1);
            ++this.numOfUniques;
        }
    }
}

