/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jgap.util.FileKit;
import org.jgap.util.JarClassLoader;

public class PluginDiscoverer {
    private static final String CVS_REVISION = "$Revision: 1.9 $";
    private static final boolean DEBUG = false;
    private List m_classpathFolders;
    private List m_classpathJars;
    private String m_jarFile;

    public PluginDiscoverer() {
        this.init();
        String classpath = System.getProperty("java.class.path");
        StringTokenizer st = new StringTokenizer(classpath, File.pathSeparator);
        while (st.hasMoreTokens()) {
            String item = st.nextToken();
            File f = new File(item);
            if (item.toLowerCase().endsWith(".jar") && f.isFile()) {
                this.m_classpathJars.add(item);
                continue;
            }
            if (!f.isDirectory()) continue;
            this.m_classpathFolders.add(item);
        }
    }

    public PluginDiscoverer(String a_jarFile) {
        this.init();
        this.m_jarFile = a_jarFile;
        this.m_classpathJars.add(this.m_jarFile);
    }

    private void init() {
        this.m_classpathFolders = new Vector();
        this.m_classpathJars = new Vector();
    }

    private String checkIfClassMatches(String a_jarFilename, Class a_interfaceClass, String a_testClass) {
        if (a_testClass.toLowerCase().endsWith(".class")) {
            a_testClass = a_testClass.substring(0, a_testClass.length() - 6);
        }
        a_testClass = a_testClass.replace('\\', '.').replace('/', '.');
        while (a_testClass.startsWith(".")) {
            a_testClass = a_testClass.substring(1);
        }
        if (a_testClass.indexOf(36) != -1) {
            return null;
        }
        try {
            ClassLoader cl = a_jarFilename == null ? this.getClass().getClassLoader() : new JarClassLoader(a_jarFilename);
            Class<?> testClassObj = Class.forName(a_testClass, false, cl);
            if (a_interfaceClass.isAssignableFrom(testClassObj)) {
                if (testClassObj.isInterface()) {
                    return null;
                }
                if ((testClassObj.getModifiers() & 0x400) > 0) {
                    return null;
                }
                return a_testClass;
            }
        }
        catch (UnsatisfiedLinkError ule) {
        }
        catch (IllegalAccessError e) {
        }
        catch (ClassNotFoundException cnfe) {
        }
        catch (NoClassDefFoundError nex) {
            // empty catch block
        }
        return null;
    }

    public List findImplementingClasses(String a_fullInterfaceName) throws ClassNotFoundException {
        Class<?> interfaceToLookFor = Class.forName(a_fullInterfaceName);
        return this.findImplementingClasses(interfaceToLookFor);
    }

    public List findImplementingClasses(Class a_intrface) {
        Vector<String> result = new Vector<String>();
        String s = null;
        try {
            File f = new File(".");
            s = f.getCanonicalPath();
            s = FileKit.getConformPath(s, true);
        }
        catch (IOException iex) {
            throw new RuntimeException("Unable to determine current directory", iex);
        }
        for (String filename : this.m_classpathJars) {
            if (!(filename = FileKit.getConformPath(filename, true)).startsWith(s)) continue;
            try {
                JarFile jar = new JarFile(filename);
                Enumeration<JarEntry> item = jar.entries();
                while (item.hasMoreElements()) {
                    String classname;
                    JarEntry entry = item.nextElement();
                    String name = entry.getName();
                    if (!name.toLowerCase().endsWith(".class") || (classname = this.checkIfClassMatches(filename, a_intrface, name)) == null) continue;
                    result.add(classname);
                }
            }
            catch (IOException e) {
                System.out.println("Unable to open jar " + filename);
            }
        }
        for (String folder : this.m_classpathFolders) {
            System.err.println(folder);
            this.findImplementingClasses0(a_intrface, result, folder, "");
        }
        return result;
    }

    private void findImplementingClasses0(Class a_intrface, List a_result, String a_base, String a_path) {
        a_result.addAll(this.findImplementingClasses(a_intrface, a_base, a_path));
        File f = new File(a_base + File.separator + a_path);
        if (!f.isDirectory()) {
            return;
        }
        File[] matches = f.listFiles(new DirectoryFilter());
        for (int i = 0; i < matches.length; ++i) {
            String folder = a_path + File.separator + matches[i].getName();
            this.findImplementingClasses0(a_intrface, a_result, a_base, folder);
        }
    }

    public List findImplementingClasses(Class a_intrface, String a_base, String a_path) {
        Vector<String> result = new Vector<String>();
        File f = new File(a_base + File.separator + a_path);
        if (!f.isDirectory()) {
            return result;
        }
        File[] matches = f.listFiles(new ClassFilter());
        for (int i = 0; i < matches.length; ++i) {
            String classname = a_path + File.separator + matches[i].getName();
            if ((classname = this.checkIfClassMatches(null, a_intrface, classname)) == null) continue;
            result.add(classname);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
        PluginDiscoverer discoverer = new PluginDiscoverer();
        List plugins = discoverer.findImplementingClasses("org.jgap.INaturalSelector");
        System.out.println();
        int size = plugins.size();
        System.out.println("" + size + " plugin" + (size == 1 ? "" : "s") + " discovered" + (size == 0 ? "" : ":"));
        for (int i = 0; i < size; ++i) {
            System.out.println(plugins.get(i));
        }
        System.exit(0);
    }

    public class DirectoryFilter
    implements FilenameFilter {
        public boolean accept(File a_dir, String a_name) {
            return a_dir != null && new File(a_dir.getPath() + File.separator + a_name).isDirectory();
        }
    }

    public class ClassFilter
    implements FilenameFilter {
        public boolean accept(File a_dir, String a_name) {
            return a_name != null && a_name.toLowerCase().endsWith(".class");
        }
    }
}

