/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.context;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.util.StringUtil;
import org.eclipse.epsilon.eol.execute.context.Frame;
import org.eclipse.epsilon.eol.execute.context.FrameType;
import org.eclipse.epsilon.eol.execute.context.Variable;

public class SingleFrame
implements Frame {
    private HashMap<String, Variable> storage = new LinkedHashMap<String, Variable>();
    private FrameType type;
    private AST entryPoint;
    private String label;
    private AST currentStatement;

    public SingleFrame(FrameType type, AST entryPoint) {
        this.type = type;
        this.entryPoint = entryPoint;
    }

    public SingleFrame(FrameType type, AST entryPoint, String label) {
        this.type = type;
        this.entryPoint = entryPoint;
        this.label = label;
    }

    @Override
    public void dispose() {
        for (Variable v : this.storage.values()) {
            v.dispose();
        }
        this.entryPoint = null;
    }

    @Override
    public void clear() {
        this.storage.clear();
        this.currentStatement = null;
    }

    public SingleFrame clone() {
        SingleFrame clone = new SingleFrame(this.type, this.entryPoint);
        clone.label = this.label;
        clone.currentStatement = this.currentStatement;
        for (Variable v : this.storage.values()) {
            clone.storage.put(v.name, v.clone());
        }
        return clone;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String label) {
        this.label = label;
    }

    @Override
    public void put(String name, Object value) {
        this.put(Variable.createReadOnlyVariable(name, value));
    }

    @Override
    public void remove(String name) {
        this.storage.remove(name);
    }

    @Override
    public void put(Variable variable) {
        this.storage.put(variable.getName(), variable);
    }

    @Override
    public void putAll(Map<String, Variable> variables) {
        this.storage.putAll(variables);
    }

    @Override
    public Variable get(String key) {
        return this.storage.get(key);
    }

    @Override
    public Map<String, Variable> getAll() {
        return this.storage;
    }

    @Override
    public boolean contains(String key) {
        return this.storage.containsKey(key);
    }

    @Override
    public FrameType getType() {
        return this.type;
    }

    @Override
    public void setType(FrameType type) {
        this.type = type;
    }

    @Override
    public AST getEntryPoint() {
        return this.entryPoint;
    }

    @Override
    public void setEntryPoint(AST entryPoint) {
        this.entryPoint = entryPoint;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("------------" + this.type + "-------------\r\n");
        for (String key : this.storage.keySet()) {
            buffer.append(key + "     " + StringUtil.toString(this.storage.get(key), "null") + "\r\n");
        }
        return buffer.toString();
    }

    @Override
    public void setCurrentStatement(AST ast) {
        this.currentStatement = ast;
    }

    @Override
    public AST getCurrentStatement() {
        return this.currentStatement;
    }
}

