/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.flock.model.domain.rules;

import java.util.Collection;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.flock.context.MigrationStrategyCheckingContext;
import org.eclipse.epsilon.flock.execution.MigrateRuleContext;
import org.eclipse.epsilon.flock.execution.exceptions.FlockRuntimeException;
import org.eclipse.epsilon.flock.model.domain.common.ClassifierTypedConstruct;
import org.eclipse.epsilon.flock.model.domain.rules.Body;
import org.eclipse.epsilon.flock.model.domain.rules.IgnoredProperties;

public class MigrateRule
extends ClassifierTypedConstruct {
    private final Body body;
    private final IgnoredProperties ignoredProperties;

    MigrateRule(AST ast, Collection<String> annotations, String originalType, Collection<String> ignoredProperties, AST guard, AST body) {
        super(ast, annotations, guard, originalType);
        this.body = new Body(body);
        this.ignoredProperties = new IgnoredProperties(ignoredProperties);
    }

    public IgnoredProperties getIgnoredProperties() {
        return this.ignoredProperties;
    }

    public String getDescriptionOfIgnoredProperties() {
        return this.ignoredProperties.isEmpty() ? "" : "ignoring " + this.ignoredProperties;
    }

    @Override
    public void check(MigrationStrategyCheckingContext context) {
        super.check(context);
        this.ignoredProperties.check(this.getOriginalType(), context);
    }

    public void gatherIgnoredPropertiesFor(MigrateRuleContext context, IgnoredProperties ignoredProperties) throws FlockRuntimeException {
        boolean applicable = context.isEligibleFor(this);
        if (applicable) {
            ignoredProperties.addAll(this.ignoredProperties);
        }
    }

    public boolean applyTo(MigrateRuleContext context) throws FlockRuntimeException {
        boolean applicable = context.isEligibleFor(this);
        if (applicable) {
            context.execute(this.body);
        }
        return applicable;
    }

    public String toString() {
        return String.valueOf(this.getAnnotationString()) + "migrate " + this.getOriginalType() + " " + "ignoring " + this.ignoredProperties + " " + "when " + this.getGuard() + " " + "do " + this.body;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof MigrateRule)) {
            return false;
        }
        MigrateRule other = (MigrateRule)object;
        return super.equals(other) && this.body.equals(other.body) && this.ignoredProperties.equals(other.ignoredProperties);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.body.hashCode() + this.ignoredProperties.hashCode();
    }
}

