/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.ewl;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.antlr.runtime.ANTLRInputStream;
import org.antlr.runtime.Lexer;
import org.antlr.runtime.TokenStream;
import org.eclipse.epsilon.common.module.ModuleElement;
import org.eclipse.epsilon.common.parse.AST;
import org.eclipse.epsilon.common.parse.EpsilonParser;
import org.eclipse.epsilon.common.util.AstUtil;
import org.eclipse.epsilon.eol.EolLibraryModule;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.execute.context.IEolContext;
import org.eclipse.epsilon.ewl.EwlWizard;
import org.eclipse.epsilon.ewl.EwlWizardInstance;
import org.eclipse.epsilon.ewl.EwlWizardLoopInstance;
import org.eclipse.epsilon.ewl.IEwlModule;
import org.eclipse.epsilon.ewl.execute.context.EwlContext;
import org.eclipse.epsilon.ewl.execute.context.IEwlContext;
import org.eclipse.epsilon.ewl.parse.EwlLexer;
import org.eclipse.epsilon.ewl.parse.EwlParser;

public class EwlModule
extends EolLibraryModule
implements IEwlModule {
    protected List<EwlWizard> templates = new ArrayList<EwlWizard>();
    protected IEwlContext context = null;

    public EwlModule() {
        this.reset();
    }

    @Override
    public Lexer createLexer(InputStream inputStream) {
        ANTLRInputStream input = null;
        try {
            input = new ANTLRInputStream(inputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new EwlLexer(input);
    }

    @Override
    public EpsilonParser createParser(TokenStream tokenStream) {
        return new EwlParser(tokenStream);
    }

    @Override
    public String getMainRule() {
        return "ewlModule";
    }

    @Override
    public void buildModel() throws Exception {
        super.buildModel();
        for (AST wizardAst : AstUtil.getChildren(this.ast, 80)) {
            EwlWizard template = new EwlWizard();
            template.build(wizardAst);
            this.templates.add(template);
        }
    }

    @Override
    public List<EwlWizardInstance> getWizardsFor(Object self) throws EolRuntimeException {
        this.prepareContext(this.context);
        ArrayList<EwlWizardInstance> applicableWizards = new ArrayList<EwlWizardInstance>();
        for (EwlWizard wizard : this.templates) {
            Collection collection;
            if (wizard.appliesTo(self, this.context)) {
                applicableWizards.add(new EwlWizardInstance(wizard, self, this.context));
                continue;
            }
            if (!(self instanceof Collection) || ((Collection)self).isEmpty() || !this.allApply(wizard, collection = (Collection)self)) continue;
            applicableWizards.add(new EwlWizardLoopInstance(wizard, collection, this.context));
        }
        return applicableWizards;
    }

    @Override
    public IEwlContext getContext() {
        return this.context;
    }

    @Override
    public List<ModuleElement> getChildren() {
        ArrayList<ModuleElement> children = new ArrayList<ModuleElement>();
        children.addAll(this.getImports());
        children.addAll(this.templates);
        children.addAll(this.getDeclaredOperations());
        return children;
    }

    @Override
    public void reset() {
        super.reset();
        this.templates = new ArrayList<EwlWizard>();
        this.context = new EwlContext();
    }

    private boolean allApply(EwlWizard wizard, Collection<Object> self) throws EolRuntimeException {
        for (Object o : self) {
            if (wizard.appliesTo(o, this.context)) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setContext(IEolContext context) {
        if (context instanceof IEwlContext) {
            this.context = (IEwlContext)context;
        }
    }
}

