/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.parse.spec;

import java.util.Collection;
import java.util.LinkedList;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.epsilon.hutn.model.hutn.HutnFactory;
import org.eclipse.epsilon.hutn.model.hutn.NsUri;
import org.eclipse.epsilon.hutn.model.hutn.Spec;
import org.eclipse.epsilon.hutn.util.StringUtil;

public class HutnSpecAstToSpec {
    private final CommonTree ast;

    public HutnSpecAstToSpec(CommonTree ast) {
        this.ast = ast;
    }

    public Spec transformPreamble() {
        Spec spec = HutnFactory.eINSTANCE.createSpec();
        for (CommonTree nsUriValueNode : this.getNsUriValueNodes()) {
            spec.getNsUris().add(HutnSpecAstToSpec.createNsUri(StringUtil.stripQuotes(nsUriValueNode.getText())));
        }
        return spec;
    }

    private Collection<CommonTree> getNsUriValueNodes() {
        LinkedList<CommonTree> nsUriValueNodes = new LinkedList<CommonTree>();
        for (Object metamodel : this.ast.getChildren()) {
            for (Object metamodelFeature : ((CommonTree)metamodel).getChildren()) {
                if (!"nsUri".equals(((CommonTree)metamodelFeature).getText())) continue;
                for (Object nsUriValueNode : ((CommonTree)metamodelFeature).getChildren()) {
                    nsUriValueNodes.add((CommonTree)nsUriValueNode);
                }
            }
        }
        return nsUriValueNodes;
    }

    private static NsUri createNsUri(String value) {
        NsUri nsUri = HutnFactory.eINSTANCE.createNsUri();
        nsUri.setValue(value);
        return nsUri;
    }
}

