/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan;

import de.lmu.ifi.dbs.elki.algorithm.clustering.correlation.COPAC;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.AbstractRangeQueryNeighborPredicate;
import de.lmu.ifi.dbs.elki.algorithm.clustering.gdbscan.NeighborPredicate;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStore;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.HashSetModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.SetDBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.minkowski.EuclideanDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.FiniteProgress;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Matrix;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAFilteredResult;
import de.lmu.ifi.dbs.elki.math.linearalgebra.pca.PCAResult;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;

@Reference(authors="E. Achtert, C. B\u00f6hm, H.-P. Kriegel, P. Kr\u00f6ger, A. Zimek", title="Robust, Complete, and Efficient Correlation Clustering", booktitle="Proc. 7th SIAM International Conference on Data Mining (SDM'07), Minneapolis, MN, 2007", url="http://www.siam.org/proceedings/datamining/2007/dm07_037achtert.pdf")
public class COPACNeighborPredicate<V extends NumberVector>
implements NeighborPredicate {
    private static final Logging LOG = Logging.getLogger(COPACNeighborPredicate.class);
    protected final COPAC.Settings settings;
    protected double epsilonsq;

    public COPACNeighborPredicate(COPAC.Settings settings) {
        this.settings = settings;
        this.epsilonsq = settings.epsilon * settings.epsilon;
    }

    @Override
    public <T> NeighborPredicate.Instance<T> instantiate(Database database, SimpleTypeInformation<?> simpleTypeInformation) {
        Relation relation = database.getRelation(TypeUtil.NUMBER_VECTOR_FIELD, new Object[0]);
        return this.instantiate(database, relation);
    }

    public Instance instantiate(Database database, Relation<V> relation) {
        DistanceQuery<NumberVector> distanceQuery = database.getDistanceQuery(relation, EuclideanDistanceFunction.STATIC, new Object[0]);
        KNNQuery<NumberVector> kNNQuery = database.getKNNQuery(distanceQuery, this.settings.k);
        WritableDataStore<COPACModel> writableDataStore = DataStoreUtil.makeStorage(relation.getDBIDs(), 3, COPACModel.class);
        Duration duration = LOG.newDuration(this.getClass().getName() + ".preprocessing-time").begin();
        FiniteProgress finiteProgress = LOG.isVerbose() ? new FiniteProgress(this.getClass().getName(), relation.size(), LOG) : null;
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            KNNList kNNList = kNNQuery.getKNNForDBID(dBIDIter, this.settings.k);
            writableDataStore.put(dBIDIter, this.computeLocalModel(dBIDIter, kNNList, relation));
            LOG.incrementProcessed(finiteProgress);
            dBIDIter.advance();
        }
        LOG.ensureCompleted(finiteProgress);
        LOG.statistics(duration.end());
        return new Instance(relation.getDBIDs(), (DataStore<COPACModel>)writableDataStore);
    }

    protected COPACModel computeLocalModel(DBIDRef dBIDRef, DoubleDBIDList doubleDBIDList, Relation<V> relation) {
        PCAResult pCAResult = this.settings.pca.processQueryResult(doubleDBIDList, relation);
        int n = ((PCAFilteredResult)pCAResult).getCorrelationDimension();
        Matrix matrix = ((PCAFilteredResult)pCAResult).similarityMatrix();
        Vector vector = ((NumberVector)relation.get(dBIDRef)).getColumnVector();
        if (n == vector.getDimensionality()) {
            return new COPACModel(n, DBIDUtil.EMPTYDBIDS);
        }
        HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet();
        DBIDIter dBIDIter = relation.iterDBIDs();
        while (dBIDIter.valid()) {
            Vector vector2 = ((NumberVector)relation.get(dBIDIter)).getColumnVector().minusEquals(vector);
            double d = vector2.transposeTimesTimes(matrix, vector2);
            if (d <= this.epsilonsq) {
                hashSetModifiableDBIDs.add(dBIDIter);
            }
            dBIDIter.advance();
        }
        return new COPACModel(n, hashSetModifiableDBIDs);
    }

    @Override
    public TypeInformation getInputTypeRestriction() {
        return TypeUtil.NUMBER_VECTOR_FIELD;
    }

    @Override
    public SimpleTypeInformation<?>[] getOutputType() {
        return new SimpleTypeInformation[]{new SimpleTypeInformation<COPACModel>(COPACModel.class)};
    }

    public static class Parameterizer<V extends NumberVector>
    extends AbstractParameterizer {
        protected COPAC.Settings settings;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            this.settings = parameterization.tryInstantiate(COPAC.Settings.class);
        }

        @Override
        protected COPACNeighborPredicate<V> makeInstance() {
            return new COPACNeighborPredicate(this.settings);
        }
    }

    public static class Instance
    extends AbstractRangeQueryNeighborPredicate.Instance<COPACModel, COPACModel> {
        public Instance(DBIDs dBIDs, DataStore<COPACModel> dataStore) {
            super(dBIDs, dataStore);
        }

        @Override
        public COPACModel getNeighbors(DBIDRef dBIDRef) {
            COPACModel cOPACModel = (COPACModel)this.storage.get(dBIDRef);
            if (cOPACModel.ids.size() <= 0) {
                return cOPACModel;
            }
            HashSetModifiableDBIDs hashSetModifiableDBIDs = DBIDUtil.newHashSet(cOPACModel.ids.size());
            DBIDIter dBIDIter = cOPACModel.ids.iter();
            while (dBIDIter.valid()) {
                COPACModel cOPACModel2 = (COPACModel)this.storage.get(dBIDIter);
                if (cOPACModel2.cdim == cOPACModel.cdim && cOPACModel2.ids.contains(dBIDRef)) {
                    hashSetModifiableDBIDs.add(dBIDIter);
                }
                dBIDIter.advance();
            }
            return new COPACModel(cOPACModel.cdim, hashSetModifiableDBIDs);
        }

        @Override
        public DBIDIter iterDBIDs(COPACModel cOPACModel) {
            return cOPACModel.ids.iter();
        }

        public int dimensionality(DBIDRef dBIDRef) {
            return ((COPACModel)this.storage.get((DBIDRef)dBIDRef)).cdim;
        }
    }

    public static class COPACModel
    implements SetDBIDs {
        int cdim;
        SetDBIDs ids;

        public COPACModel(int n, SetDBIDs setDBIDs) {
            this.cdim = n;
            this.ids = setDBIDs;
        }

        @Override
        public DBIDIter iter() {
            return this.ids.iter();
        }

        @Override
        public int size() {
            return this.ids.size();
        }

        @Override
        public boolean contains(DBIDRef dBIDRef) {
            return this.ids.contains(dBIDRef);
        }

        @Override
        public boolean isEmpty() {
            return this.ids.isEmpty();
        }
    }
}

