/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.relation;

import de.lmu.ifi.dbs.elki.data.projection.Projection;
import de.lmu.ifi.dbs.elki.data.type.SimpleTypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.AbstractRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;

public class ProjectedView<IN, OUT>
extends AbstractRelation<OUT> {
    private static final Logging LOG = Logging.getLogger(ProjectedView.class);
    private final Relation<IN> inner;
    private Projection<IN, OUT> projection;

    public ProjectedView(Relation<IN> relation, Projection<IN, OUT> projection) {
        this.inner = relation;
        this.projection = projection;
        projection.initialize(relation.getDataTypeInformation());
    }

    @Override
    public String getLongName() {
        return "projection";
    }

    @Override
    public String getShortName() {
        return "projection";
    }

    @Override
    public OUT get(DBIDRef dBIDRef) {
        return this.projection.project(this.inner.get(dBIDRef));
    }

    @Override
    public SimpleTypeInformation<OUT> getDataTypeInformation() {
        return this.projection.getOutputDataTypeInformation();
    }

    @Override
    public DBIDs getDBIDs() {
        return this.inner.getDBIDs();
    }

    @Override
    public DBIDIter iterDBIDs() {
        return this.inner.iterDBIDs();
    }

    @Override
    public int size() {
        return this.inner.size();
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

