/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index;

import de.lmu.ifi.dbs.elki.index.Index;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.persistent.ExternalizablePage;
import de.lmu.ifi.dbs.elki.persistent.MemoryPageFileFactory;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import de.lmu.ifi.dbs.elki.persistent.PageFileFactory;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;

public abstract class PagedIndexFactory<O, I extends Index>
implements IndexFactory<O, I> {
    private PageFileFactory<?> pageFileFactory;

    public PagedIndexFactory(PageFileFactory<?> pageFileFactory) {
        this.pageFileFactory = pageFileFactory;
    }

    protected <N extends ExternalizablePage> PageFile<N> makePageFile(Class<N> clazz) {
        PageFileFactory<?> pageFileFactory = this.pageFileFactory;
        return pageFileFactory.newPageFile(clazz);
    }

    public static abstract class Parameterizer<O>
    extends AbstractParameterizer {
        public static final OptionID PAGEFILE_ID = new OptionID("index.pagefile", "The pagefile factory for storing the index.");
        protected PageFileFactory<?> pageFileFactory;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            ObjectParameter objectParameter = new ObjectParameter(PAGEFILE_ID, (Class<?>)PageFileFactory.class, MemoryPageFileFactory.class);
            if (parameterization.grab(objectParameter)) {
                this.pageFileFactory = (PageFileFactory)objectParameter.instantiateClass(parameterization);
            }
        }

        @Override
        protected abstract PagedIndexFactory<O, ?> makeInstance();
    }
}

