/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.idistance;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMedoidsInitialization;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListMIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNHeap;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.query.range.RangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.DistanceFunction;
import de.lmu.ifi.dbs.elki.index.AbstractRefiningIndex;
import de.lmu.ifi.dbs.elki.index.IndexFactory;
import de.lmu.ifi.dbs.elki.index.KNNIndex;
import de.lmu.ifi.dbs.elki.index.RangeIndex;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.DoubleStatistic;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.math.MeanVarianceMinMax;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.CommonConstraints;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ObjectParameter;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleIntPair;
import java.util.Arrays;

@Reference(authors="C. Yu, B. C. Ooi, K. L. Tan, H. V. Jagadish", title="Indexing the distance: An efficient method to knn processing", booktitle="In Proceedings of the 27th International Conference on Very Large Data Bases", url="http://www.vldb.org/conf/2001/P421.pdf")
public class InMemoryIDistanceIndex<O>
extends AbstractRefiningIndex<O>
implements RangeIndex<O>,
KNNIndex<O> {
    private static final Logging LOG = Logging.getLogger(InMemoryIDistanceIndex.class);
    private DistanceQuery<O> distanceQuery;
    private KMedoidsInitialization<O> initialization;
    private int numref;
    private ArrayDBIDs referencepoints;
    private ModifiableDoubleDBIDList[] index;
    @Reference(authors="H. V. Jagadish, B. C. Ooi, K. L. Tan, C. Yu, R. Zhang", title="iDistance: An adaptive B+-tree based indexing method for nearest neighbor search", booktitle="ACM Transactions on Database Systems (TODS), 30(2), 364-397")
    public static final Void SECOND_REFERENCE = null;

    public InMemoryIDistanceIndex(Relation<O> relation, DistanceQuery<O> distanceQuery, KMedoidsInitialization<O> kMedoidsInitialization, int n) {
        super(relation);
        this.distanceQuery = distanceQuery;
        this.initialization = kMedoidsInitialization;
        this.numref = n;
        if (!distanceQuery.getDistanceFunction().isMetric()) {
            LOG.warning("iDistance assumes metric distance functions.\n" + distanceQuery.getDistanceFunction().getClass() + " does not report itself as metric.\n" + "iDistance will run, but may yield approximate results.");
        }
    }

    @Override
    public void initialize() {
        this.referencepoints = DBIDUtil.ensureArray(this.initialization.chooseInitialMedoids(this.numref, this.relation.getDBIDs(), this.distanceQuery));
        int n = this.referencepoints.size();
        this.index = new ModifiableDoubleDBIDList[n];
        for (int i = 0; i < n; ++i) {
            this.index[i] = DBIDUtil.newDistanceDBIDList(this.relation.size() / (2 * n));
        }
        DBIDArrayIter dBIDArrayIter = this.referencepoints.iter();
        DBIDIter dBIDIter = this.relation.iterDBIDs();
        while (dBIDIter.valid()) {
            double d = Double.POSITIVE_INFINITY;
            int n2 = -1;
            dBIDArrayIter.seek(0);
            while (dBIDArrayIter.valid()) {
                double d2 = this.distanceQuery.distance((DBIDRef)dBIDIter, (DBIDRef)dBIDArrayIter);
                if (d2 < d) {
                    d = d2;
                    n2 = dBIDArrayIter.getOffset();
                }
                dBIDArrayIter.advance();
            }
            assert (n2 >= 0 && n2 < n);
            this.index[n2].add(d, dBIDIter);
            dBIDIter.advance();
        }
        for (int i = 0; i < n; ++i) {
            this.index[i].sort();
        }
    }

    @Override
    public KNNQuery<O> getKNNQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            if (LOG.isDebugging()) {
                LOG.debug("Distance function not supported by index - or 'equals' not implemented right!");
            }
            return null;
        }
        return new IDistanceKNNQuery(distanceQuery);
    }

    @Override
    public RangeQuery<O> getRangeQuery(DistanceQuery<O> distanceQuery, Object ... objectArray) {
        if (distanceQuery.getRelation() != this.relation) {
            return null;
        }
        DistanceFunction<O> distanceFunction = distanceQuery.getDistanceFunction();
        if (!this.getDistanceFunction().equals(distanceFunction)) {
            if (LOG.isDebugging()) {
                LOG.debug("Distance function not supported by index - or 'equals' not implemented right!");
            }
            return null;
        }
        return new IDistanceRangeQuery(distanceQuery);
    }

    private DistanceFunction<? super O> getDistanceFunction() {
        return this.distanceQuery.getDistanceFunction();
    }

    @Override
    public String getLongName() {
        return "iDistance index";
    }

    @Override
    public String getShortName() {
        return "idistance-index";
    }

    @Override
    public Logging getLogger() {
        return LOG;
    }

    @Override
    public void logStatistics() {
        super.logStatistics();
        MeanVarianceMinMax meanVarianceMinMax = new MeanVarianceMinMax();
        for (int i = 0; i < this.index.length; ++i) {
            meanVarianceMinMax.put(this.index[i].size());
        }
        LOG.statistics(new LongStatistic(InMemoryIDistanceIndex.class.getName() + ".size.min", (int)meanVarianceMinMax.getMin()));
        LOG.statistics(new DoubleStatistic(InMemoryIDistanceIndex.class.getName() + ".size.mean", meanVarianceMinMax.getMean()));
        LOG.statistics(new LongStatistic(InMemoryIDistanceIndex.class.getName() + ".size.max", (int)meanVarianceMinMax.getMax()));
    }

    protected static <O> DoubleIntPair[] rankReferencePoints(DistanceQuery<O> distanceQuery, O o, ArrayDBIDs arrayDBIDs) {
        Object[] objectArray = new DoubleIntPair[arrayDBIDs.size()];
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        while (dBIDArrayIter.valid()) {
            int n = dBIDArrayIter.getOffset();
            double d = distanceQuery.distance((DBIDArrayIter)o, dBIDArrayIter);
            objectArray[n] = new DoubleIntPair(d, n);
            dBIDArrayIter.advance();
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    protected static void binarySearch(ModifiableDoubleDBIDList modifiableDoubleDBIDList, DoubleDBIDListIter doubleDBIDListIter, double d) {
        int n = 0;
        int n2 = modifiableDoubleDBIDList.size();
        while (n < n2) {
            int n3 = n + n2 >>> 1;
            double d2 = doubleDBIDListIter.seek(n3).doubleValue();
            if (d < d2) {
                n2 = n3;
                continue;
            }
            if (d > d2) {
                n = n3 + 1;
                continue;
            }
            n = n3;
            break;
        }
        if (n >= modifiableDoubleDBIDList.size()) {
            --n;
        }
        doubleDBIDListIter.seek(n);
    }

    public static class Factory<V>
    implements IndexFactory<V, InMemoryIDistanceIndex<V>> {
        DistanceFunction<? super V> distance;
        KMedoidsInitialization<V> initialization;
        int k;

        public Factory(DistanceFunction<? super V> distanceFunction, KMedoidsInitialization<V> kMedoidsInitialization, int n) {
            this.distance = distanceFunction;
            this.initialization = kMedoidsInitialization;
            this.k = n;
        }

        @Override
        public InMemoryIDistanceIndex<V> instantiate(Relation<V> relation) {
            return new InMemoryIDistanceIndex<V>(relation, this.distance.instantiate(relation), this.initialization, this.k);
        }

        @Override
        public TypeInformation getInputTypeRestriction() {
            return this.distance.getInputTypeRestriction();
        }

        public static class Parameterizer<V>
        extends AbstractParameterizer {
            public static final OptionID DISTANCE_ID = new OptionID("idistance.distance", "Distance function to build the index for.");
            public static final OptionID REFERENCE_ID = new OptionID("idistance.reference", "Method to choose the reference points.");
            public static final OptionID K_ID = new OptionID("idistance.k", "Number of reference points to use.");
            DistanceFunction<? super V> distance;
            KMedoidsInitialization<V> initialization;
            int k;

            @Override
            protected void makeOptions(Parameterization parameterization) {
                IntParameter intParameter;
                ObjectParameter objectParameter;
                super.makeOptions(parameterization);
                ObjectParameter objectParameter2 = new ObjectParameter(DISTANCE_ID, DistanceFunction.class);
                if (parameterization.grab(objectParameter2)) {
                    this.distance = (DistanceFunction)objectParameter2.instantiateClass(parameterization);
                }
                if (parameterization.grab(objectParameter = new ObjectParameter(REFERENCE_ID, KMedoidsInitialization.class))) {
                    this.initialization = (KMedoidsInitialization)objectParameter.instantiateClass(parameterization);
                }
                if (parameterization.grab(intParameter = (IntParameter)new IntParameter(K_ID).addConstraint(CommonConstraints.GREATER_EQUAL_ONE_INT))) {
                    this.k = intParameter.intValue();
                }
            }

            @Override
            protected Factory<V> makeInstance() {
                return new Factory<V>(this.distance, this.initialization, this.k);
            }
        }
    }

    protected class IDistanceRangeQuery
    extends AbstractRefiningIndex.AbstractRangeQuery {
        public IDistanceRangeQuery(DistanceQuery<O> distanceQuery) {
            super(distanceQuery);
        }

        @Override
        public void getRangeForObject(O o, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
            DoubleIntPair[] doubleIntPairArray;
            for (DoubleIntPair doubleIntPair : doubleIntPairArray = InMemoryIDistanceIndex.rankReferencePoints(this.distanceQuery, o, InMemoryIDistanceIndex.this.referencepoints)) {
                double d2;
                ModifiableDoubleDBIDList modifiableDoubleDBIDList2 = InMemoryIDistanceIndex.this.index[doubleIntPair.second];
                double d3 = doubleIntPair.first;
                DoubleDBIDListMIter doubleDBIDListMIter = modifiableDoubleDBIDList2.iter();
                DoubleDBIDListMIter doubleDBIDListMIter2 = modifiableDoubleDBIDList2.iter();
                InMemoryIDistanceIndex.binarySearch(modifiableDoubleDBIDList2, doubleDBIDListMIter2, d3);
                doubleDBIDListMIter.seek(doubleDBIDListMIter2.getOffset() + 1);
                double d4 = doubleDBIDListMIter.valid() ? Math.abs(doubleDBIDListMIter.doubleValue() - d3) : Double.NaN;
                double d5 = d2 = doubleDBIDListMIter2.valid() ? Math.abs(doubleDBIDListMIter2.doubleValue() - d3) : Double.NaN;
                while (d4 <= d || d2 <= d) {
                    double d6;
                    if (d4 <= d && !(d4 > d2)) {
                        d6 = this.refine(doubleDBIDListMIter, o);
                        if (d6 <= d) {
                            modifiableDoubleDBIDList.add(d6, doubleDBIDListMIter);
                        }
                        doubleDBIDListMIter.advance();
                        double d7 = d4 = doubleDBIDListMIter.valid() ? Math.abs(doubleDBIDListMIter.doubleValue() - d3) : Double.NaN;
                    }
                    if (!(d2 <= d) || d2 > d4) continue;
                    d6 = this.refine(doubleDBIDListMIter2, o);
                    if (d6 <= d) {
                        modifiableDoubleDBIDList.add(d6, doubleDBIDListMIter2);
                    }
                    doubleDBIDListMIter2.retract();
                    d2 = doubleDBIDListMIter2.valid() ? Math.abs(doubleDBIDListMIter2.doubleValue() - d3) : Double.NaN;
                }
            }
        }
    }

    protected class IDistanceKNNQuery
    extends AbstractRefiningIndex.AbstractKNNQuery {
        public IDistanceKNNQuery(DistanceQuery<O> distanceQuery) {
            super(distanceQuery);
        }

        @Override
        public KNNList getKNNForObject(O o, int n) {
            DoubleIntPair[] doubleIntPairArray = InMemoryIDistanceIndex.rankReferencePoints(this.distanceQuery, o, InMemoryIDistanceIndex.this.referencepoints);
            KNNHeap kNNHeap = DBIDUtil.newHeap(n);
            for (DoubleIntPair doubleIntPair : doubleIntPairArray) {
                ModifiableDoubleDBIDList modifiableDoubleDBIDList = InMemoryIDistanceIndex.this.index[doubleIntPair.second];
                double d = doubleIntPair.first;
                DoubleDBIDListMIter doubleDBIDListMIter = modifiableDoubleDBIDList.iter();
                DoubleDBIDListMIter doubleDBIDListMIter2 = modifiableDoubleDBIDList.iter();
                InMemoryIDistanceIndex.binarySearch(modifiableDoubleDBIDList, doubleDBIDListMIter2, d);
                doubleDBIDListMIter.seek(doubleDBIDListMIter2.getOffset() + 1);
                double d2 = doubleDBIDListMIter.valid() ? Math.abs(doubleDBIDListMIter.doubleValue() - d) : Double.NaN;
                double d3 = doubleDBIDListMIter2.valid() ? Math.abs(doubleDBIDListMIter2.doubleValue() - d) : Double.NaN;
                double d4 = kNNHeap.getKNNDistance();
                while (d2 <= d4 || d3 <= d4) {
                    double d5;
                    if (d2 <= d4 && !(d2 > d3)) {
                        d5 = this.refine(doubleDBIDListMIter, o);
                        if (d5 <= d4) {
                            kNNHeap.insert(d5, doubleDBIDListMIter);
                            d4 = kNNHeap.getKNNDistance();
                        }
                        doubleDBIDListMIter.advance();
                        double d6 = d2 = doubleDBIDListMIter.valid() ? Math.abs(doubleDBIDListMIter.doubleValue() - d) : Double.NaN;
                    }
                    if (!(d3 <= d4) || d3 > d2) continue;
                    d5 = this.refine(doubleDBIDListMIter2, o);
                    if (d5 <= d4) {
                        kNNHeap.insert(d5, doubleDBIDListMIter2);
                        d4 = kNNHeap.getKNNDistance();
                    }
                    doubleDBIDListMIter2.retract();
                    d3 = doubleDBIDListMIter2.valid() ? Math.abs(doubleDBIDListMIter2.doubleValue() - d) : Double.NaN;
                }
            }
            return kNNHeap.toKNNList();
        }
    }
}

