/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.logging;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class ELKILogRecord
extends LogRecord {
    private static final long serialVersionUID = 2820476270420700176L;
    private transient boolean needToInferCaller = true;
    public static final String[] IGNORE_CLASSES = new String[]{Logger.class.getCanonicalName(), Logging.class.getCanonicalName(), LoggingUtil.class.getCanonicalName(), ELKILogRecord.class.getCanonicalName(), "de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.AbstractParameterization", "de.lmu.ifi.dbs.elki.application.AbstractApplication"};
    private static final String START_TRACE_AT = Logger.class.getCanonicalName();

    public ELKILogRecord(Level level, CharSequence charSequence) {
        super(level, charSequence != null ? charSequence.toString() : null);
    }

    @Override
    public String getSourceClassName() {
        if (this.needToInferCaller) {
            this.inferCallerELKI();
        }
        return super.getSourceClassName();
    }

    @Override
    public void setSourceClassName(String string) {
        super.setSourceClassName(string);
        this.needToInferCaller = false;
    }

    @Override
    public String getSourceMethodName() {
        if (this.needToInferCaller) {
            this.inferCallerELKI();
        }
        return super.getSourceMethodName();
    }

    @Override
    public void setSourceMethodName(String string) {
        super.setSourceMethodName(string);
        this.needToInferCaller = false;
    }

    private final void inferCallerELKI() {
        StackTraceElement stackTraceElement;
        String string;
        int n;
        this.needToInferCaller = false;
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        for (n = 0; n < stackTraceElementArray.length && !(string = (stackTraceElement = stackTraceElementArray[n]).getClassName()).equals(START_TRACE_AT); ++n) {
        }
        while (n < stackTraceElementArray.length) {
            stackTraceElement = stackTraceElementArray[n];
            string = stackTraceElement.getClassName();
            boolean bl = false;
            for (int i = 0; i < IGNORE_CLASSES.length; ++i) {
                if (!string.equals(IGNORE_CLASSES[i])) continue;
                bl = true;
                break;
            }
            if (!bl) {
                super.setSourceClassName(stackTraceElement.getClassName());
                super.setSourceMethodName(stackTraceElement.getMethodName());
                break;
            }
            ++n;
        }
    }
}

