/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.result.textwriter;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.textwriter.StreamFactory;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.zip.GZIPOutputStream;

public class MultipleFilesOutput
implements StreamFactory {
    private static final String EXTENSION = ".txt";
    private static final String GZIP_EXTENSION = ".gz";
    private File basename;
    private boolean usegzip = false;
    private static final Logging LOG = Logging.getLogger(MultipleFilesOutput.class);

    public MultipleFilesOutput(File file) {
        this(file, false);
    }

    public MultipleFilesOutput(File file, boolean bl) {
        this.basename = file;
        this.usegzip = bl;
    }

    private PrintStream newStream(String string) throws IOException {
        if (LOG.isDebuggingFiner()) {
            LOG.debugFiner("Requested stream: " + string);
        }
        if (!this.basename.exists()) {
            this.basename.mkdirs();
        }
        String string2 = this.basename.getAbsolutePath() + File.separator + string + EXTENSION;
        if (this.usegzip) {
            string2 = string2 + GZIP_EXTENSION;
        }
        File file = new File(string2);
        OutputStream outputStream = new FileOutputStream(file);
        if (this.usegzip) {
            outputStream = new GZIPOutputStream(outputStream);
        }
        PrintStream printStream = new PrintStream(outputStream);
        if (LOG.isDebuggingFiner()) {
            LOG.debugFiner("Opened new output stream:" + string2);
        }
        return printStream;
    }

    @Override
    public PrintStream openStream(String string) throws IOException {
        return this.newStream(string);
    }

    @Override
    public void closeStream(PrintStream printStream) {
        printStream.close();
    }

    protected boolean isGzipCompression() {
        return this.usegzip;
    }

    protected void setGzipCompression(boolean bl) {
        this.usegzip = bl;
    }
}

