/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.distr.grid.gp;

import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.CompactWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;
import org.homedns.dade.jcgrid.GridNodeConfig;
import org.homedns.dade.jcgrid.WorkRequest;
import org.homedns.dade.jcgrid.client.GridNodeClientConfig;
import org.homedns.dade.jcgrid.cmd.MainCmd;
import org.homedns.dade.jcgrid.message.GridMessage;
import org.homedns.dade.jcgrid.message.GridMessageWorkRequest;
import org.homedns.dade.jcgrid.message.GridMessageWorkResult;
import org.jgap.RandomGenerator;
import org.jgap.distr.MasterInfo;
import org.jgap.distr.grid.DummyGridClientMediator;
import org.jgap.distr.grid.IGridClientMediator;
import org.jgap.distr.grid.MessageContext;
import org.jgap.distr.grid.common.ClientStatus;
import org.jgap.distr.grid.common.NoWorkResultsFoundException;
import org.jgap.distr.grid.common.ResultVerification;
import org.jgap.distr.grid.common.WorkRequestsSendException;
import org.jgap.distr.grid.common.WorkResultNotFoundException;
import org.jgap.distr.grid.gp.IClientEvolveStrategyGP;
import org.jgap.distr.grid.gp.IClientFeedbackGP;
import org.jgap.distr.grid.gp.IGridConfigurationGP;
import org.jgap.distr.grid.gp.IRequestSplitStrategyGP;
import org.jgap.distr.grid.gp.JGAPGPXStream;
import org.jgap.distr.grid.gp.JGAPRequestGP;
import org.jgap.distr.grid.gp.JGAPResultGP;
import org.jgap.distr.grid.gp.NullClientFeedbackGP;
import org.jgap.distr.grid.util.GridKit;
import org.jgap.distr.grid.wan.WANUtils;
import org.jgap.gp.BaseGPChromosome;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.GPGenotype;
import org.jgap.gp.impl.GPPopulation;
import org.jgap.util.DateKit;
import org.jgap.util.FileKit;
import org.jgap.util.NumberKit;
import org.jgap.util.PersistableObject;
import org.jgap.util.SystemKit;

public class JGAPClientGP
extends Thread {
    private static final String CVS_REVISION = "$Revision: 1.21 $";
    public static final String APP_VERSION = "1.02a";
    public static final String MODULE_CS = "CS";
    public static final String CLIENT_DATABASE = "clientdbGP.jgap";
    public static final String RESULTS_DATABASE = "results.jgap";
    public static final String MODULE_SC = "SC";
    public static final String MODULE_SW = "SW";
    public static final String MODULE_WS = "WS";
    public static final String MODULE_ANY = "*";
    public static final String CONTEXT_WORK_REQUEST = "WREQ";
    public static final String CONTEXT_WORK_RESULT = "WRES";
    public static final String CONTEXT_ANY = "W*";
    public static final String CONTEXT_ID_EMPTY = "0";
    public static final String CONTEXT_ID_ANY = "*";
    public static final int TIMEOUT_SECONDS = 20;
    public static final int WAITTIME_SECONDS = 5;
    public static final Object[][] FIELDSTOSKIP = new Object[][]{{GPPopulation.class, "m_fitnessRank"}, {GPPopulation.class, "m_fittestProgram"}, {GPPopulation.class, "m_changed"}, {GPPopulation.class, "m_sorted"}, {GPPopulation.class, "m_fittestToAdd"}, {BaseGPChromosome.class, "m_ind"}};
    private static transient Logger log = Logger.getLogger(JGAPClientGP.class);
    protected GridNodeClientConfig m_gridconfig;
    protected JGAPRequestGP m_workReq;
    private IGridClientMediator m_gcmed;
    private IGridConfigurationGP m_gridConfig;
    private boolean m_WANMode;
    private boolean m_receiveOnly;
    private boolean m_list;
    private String m_workDir;
    private String m_ntbResultsDir;
    private String m_runID;
    private boolean m_endless;
    private ClientStatus m_objects;
    private PersistableObject m_persister;
    private ResultVerification m_resultsVerified;
    private PersistableObject m_resultsPersister;
    private int m_requestIdx;
    private boolean m_no_comm;
    private boolean m_no_evolution;
    private int m_max_fetch_results;

    public JGAPClientGP(GridNodeClientConfig a_gridconfig, String a_clientClassName, boolean a_WANMode, boolean a_receiveOnly, boolean a_list, boolean a_no_comm, boolean a_no_evolution, boolean a_endless, int a_max_fetch_results) throws Exception {
        this(null, a_gridconfig, a_clientClassName, a_WANMode, a_receiveOnly, a_list, a_no_comm, a_no_evolution, a_endless, a_max_fetch_results);
        this.m_gcmed = new DummyGridClientMediator(this.m_gridconfig);
    }

    public JGAPClientGP(IGridClientMediator a_gcmed, GridNodeClientConfig a_gridconfig, String a_clientClassName, boolean a_WANMode, boolean a_receiveOnly, boolean a_list, boolean a_no_comm, boolean a_no_evolution, boolean a_endless, int a_max_fetch_results) throws Exception {
        log.info((Object)"This is JGAP Grid version 1.02a");
        this.m_runID = this.getRunID();
        log.info((Object)("ID of this run: " + this.m_runID));
        if (a_clientClassName == null || a_clientClassName.length() < 1) {
            throw new IllegalArgumentException("Please specify a class name of the configuration!");
        }
        this.m_WANMode = a_WANMode;
        this.m_receiveOnly = a_receiveOnly;
        if (this.m_receiveOnly) {
            log.info((Object)"Only receive results");
        }
        this.m_list = a_list;
        if (this.m_list) {
            log.info((Object)"List requests and results");
        }
        this.m_endless = a_endless;
        if (this.m_endless) {
            log.info((Object)"Endless run");
        }
        this.m_no_comm = a_no_comm;
        if (this.m_no_comm) {
            log.info((Object)"Don't send or receive anything");
        }
        this.m_no_evolution = a_no_evolution;
        if (this.m_no_evolution) {
            log.info((Object)"Don't execute genetic evolution");
        }
        this.m_max_fetch_results = a_max_fetch_results;
        if (this.m_max_fetch_results <= 0) {
            this.m_max_fetch_results = 500;
        }
        log.info((Object)("Maximum number of results to fetch at once: " + this.m_max_fetch_results));
        this.m_gridconfig = a_gridconfig;
        Class<?> client = Class.forName(a_clientClassName);
        this.m_gridConfig = (IGridConfigurationGP)client.getConstructor(new Class[0]).newInstance(new Object[0]);
        this.m_gridConfig.initialize(this.m_gridconfig);
        if (this.m_gridConfig.getClientFeedback() == null) {
            this.m_gridConfig.setClientFeedback(new NullClientFeedbackGP());
        }
        JGAPRequestGP req = new JGAPRequestGP(this.m_gridconfig.getSessionName(), this.m_runID + "_" + this.m_requestIdx, 0, this.m_gridConfig);
        ++this.m_requestIdx;
        req.setWorkerReturnStrategy(this.m_gridConfig.getWorkerReturnStrategy());
        req.setGenotypeInitializer(this.m_gridConfig.getGenotypeInitializer());
        req.setEvolveStrategy(this.m_gridConfig.getWorkerEvolveStrategy());
        MasterInfo requester = new MasterInfo(true);
        req.setRequesterInfo(requester);
        req.setRequestDate(DateKit.now());
        this.setWorkRequest(req);
        this.m_gcmed = a_gcmed;
        this.init();
    }

    private void init() throws Exception {
        if (this.getWorkDirectory() == null) {
            String workDir = FileKit.getCurrentDir() + "/work/" + "storage";
            workDir = FileKit.getConformPath(workDir);
            this.setWorkDirectory(workDir);
        }
        this.m_ntbResultsDir = FileKit.addSubDir(this.getWorkDirectory(), "ntb", true);
        FileKit.createDirectory(this.m_ntbResultsDir);
        log.info((Object)("NTB dir: " + this.m_ntbResultsDir));
        File f = new File(this.getWorkDirectory(), CLIENT_DATABASE);
        this.m_persister = new PersistableObject(f);
        this.m_objects = (ClientStatus)this.m_persister.load();
        if (this.m_objects == null) {
            this.m_objects = new ClientStatus();
            this.m_persister.setObject(this.m_objects);
        }
        f = new File(this.getWorkDirectory(), RESULTS_DATABASE);
        this.m_resultsPersister = new PersistableObject(f);
        this.m_resultsVerified = (ResultVerification)this.m_resultsPersister.load();
        if (this.m_resultsVerified == null) {
            this.m_resultsVerified = new ResultVerification();
            this.m_resultsPersister.setObject(this.m_resultsVerified);
        }
    }

    protected String getRunID() {
        if (this.m_runID == null) {
            return "RJGrid" + DateKit.getNowAsString();
        }
        return this.m_runID;
    }

    public void setWorkRequest(JGAPRequestGP a_request) {
        this.m_workReq = a_request;
    }

    protected void onBeginOfRunning() throws Exception {
    }

    protected boolean beforeSendWorkRequests(JGAPRequestGP[] a_workRequests) throws Exception {
        return true;
    }

    protected boolean beforeGenerateWorkRequests() throws Exception {
        return true;
    }

    protected boolean afterSendWorkRequests(JGAPRequestGP[] a_workRequests) throws Exception {
        return true;
    }

    protected void errorOnSendWorkRequests(Throwable uex, JGAPRequestGP[] a_workRequests) throws Exception {
    }

    protected void beforeEvolve(IGridClientMediator a_gcmed) throws Exception {
    }

    protected void afterEvolve(IGridClientMediator a_gcmed) throws Exception {
    }

    protected void afterStopped(Throwable a_t) throws Exception {
    }

    protected void onError(Exception a_ex) throws Exception {
        throw a_ex;
    }

    protected void onDeleteError(Exception a_ex) throws Exception {
        throw a_ex;
    }

    protected void onErrorReceiveWorkResults(JGAPRequestGP[] a_workRequests, Exception a_ex) throws Exception {
        throw a_ex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            try {
                String libDir = "D:\\jgap\robocode\\rjgrid\\lib\\";
            }
            catch (Exception ex) {
                log.error((Object)"Check for updates failed", (Throwable)ex);
            }
            while (true) {
                boolean showResultsError = false;
                while (true) {
                    boolean doBreak = false;
                    try {
                        this.onBeginOfRunning();
                        if (!showResultsError) {
                            try {
                                this.showCurrentResults();
                            }
                            catch (Exception ex) {
                                log.error((Object)"Error during showing current results", (Throwable)ex);
                                showResultsError = true;
                            }
                        }
                        Iterator<String> it = this.m_objects.getResults().keySet().iterator();
                        boolean modified = false;
                        try {
                            while (it.hasNext()) {
                                String key = it.next();
                                String value = this.m_objects.getResults().get(key);
                                if (this.startsWith(value, "delete:")) {
                                    log.info((Object)("Delete result (deferred), key: " + key));
                                    try {
                                        this.m_gcmed.removeMessage(key);
                                    }
                                    catch (MalformedURLException mex) {
                                        log.warn((Object)"Invalid key", (Throwable)mex);
                                    }
                                    catch (Exception ex) {
                                        this.onDeleteError(ex);
                                        continue;
                                    }
                                    it.remove();
                                    modified = true;
                                    continue;
                                }
                                if (!this.startsWith(value, "delete")) continue;
                                it.remove();
                                modified = true;
                            }
                        }
                        finally {
                            if (modified) {
                                this.m_persister.save();
                                modified = false;
                            }
                        }
                        try {
                            try {
                                IClientEvolveStrategyGP clientEvolver;
                                if (this.m_list) {
                                    this.listRequests();
                                    this.listResults();
                                }
                                if (!this.m_receiveOnly && !this.m_no_evolution && (clientEvolver = this.m_gridConfig.getClientEvolveStrategy()) != null) {
                                    clientEvolver.initialize(this.m_gcmed, this.getConfiguration(), this.m_gridConfig.getClientFeedback());
                                }
                                if (!this.m_no_evolution) {
                                    this.beforeEvolve(this.m_gcmed);
                                    this.evolve(this.m_gcmed, this.m_receiveOnly);
                                    this.afterEvolve(this.m_gcmed);
                                }
                                doBreak = true;
                            }
                            catch (Exception ex) {
                                log.error((Object)"Error: ", (Throwable)ex);
                                throw ex;
                            }
                        }
                        finally {
                            Throwable t = null;
                            try {
                                try {
                                    this.m_gcmed.stop();
                                }
                                catch (Throwable t1) {
                                    t = t1;
                                }
                            }
                            finally {
                                log.info((Object)"Calling afterStopped");
                                this.afterStopped(t);
                                if (!doBreak) continue;
                            }
                        }
                    }
                    catch (Exception ex1) {
                        try {
                            log.info((Object)"before onError");
                            this.onError(ex1);
                        }
                        catch (Exception ex) {
                            log.fatal((Object)"Unpredicted error", (Throwable)ex);
                            this.m_gridConfig.getClientFeedback().error("Error while doing the work", ex);
                            JGAPClientGP.sleep(10000L);
                        }
                        continue;
                    }
                    break;
                }
                if (this.m_endless) {
                    log.info((Object)"Starting again after a short break...");
                    JGAPClientGP.sleep(15000L);
                    continue;
                }
                break;
            }
        }
        catch (InterruptedException iex) {
            log.fatal((Object)"Thread was interrupted", (Throwable)iex);
            try {
                this.m_gcmed.disconnect();
            }
            catch (Exception ex) {
                log.warn((Object)"Disconnect after interruption failed", (Throwable)ex);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        log.info((Object)"Stopping client");
    }

    protected JGAPRequestGP[] sendWorkRequests(int a_evolutionIndex, IClientEvolveStrategyGP evolver, IRequestSplitStrategyGP splitter, IClientFeedbackGP feedback) throws Exception {
        JGAPRequestGP[] workRequests = null;
        if (this.beforeGenerateWorkRequests()) {
            log.info((Object)("Beginning evolution cycle " + a_evolutionIndex));
            try {
                workRequests = evolver.generateWorkRequests(this.m_workReq, splitter, null);
                feedback.setProgressMaximum(0);
                feedback.setProgressMaximum(workRequests.length - 1);
                for (int i = 0; i < workRequests.length; ++i) {
                    log.info((Object)("Setting up work request " + i));
                    this.presetPopulation(workRequests[i]);
                }
                if (this.beforeSendWorkRequests(workRequests)) {
                    if (!this.m_no_comm) {
                        try {
                            this.sendWorkRequests(workRequests);
                            return workRequests;
                        }
                        catch (Exception ex) {
                            throw new WorkRequestsSendException(ex, workRequests);
                        }
                    }
                    return workRequests;
                }
                return null;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw ex;
            }
        }
        return null;
    }

    protected void sendWorkRequests(JGAPRequestGP[] a_workList) throws Exception {
        for (int i = 0; i < a_workList.length; ++i) {
            JGAPRequestGP req = a_workList[i];
            req.setRequestDate(DateKit.now());
            GPPopulation pop = req.getPopulation();
            if (pop == null || pop.isFirstEmpty()) {
                log.debug((Object)"Population to send to worker is empty!");
            } else {
                GPGenotype.checkErroneousPop(pop, " before sending to worker", true);
            }
            this.m_gridConfig.getClientFeedback().sendingFragmentRequest(req);
            MessageContext context = new MessageContext(MODULE_CS, CONTEXT_WORK_REQUEST, CONTEXT_ID_EMPTY);
            context.setVersion(APP_VERSION);
            this.m_gcmed.send((GridMessage)new GridMessageWorkRequest((WorkRequest)req), context, null);
            if (this.isInterrupted()) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void receiveWorkResults(JGAPRequestGP[] workList) throws Exception {
        block18: {
            log.info((Object)"Receiving work results...");
            IClientFeedbackGP feedback = this.m_gridConfig.getClientFeedback();
            int size = workList == null ? -1 : workList.length;
            if (this.m_WANMode) {
                MessageContext context = new MessageContext(MODULE_WS, CONTEXT_WORK_RESULT, CONTEXT_ID_EMPTY);
                List results = this.m_gcmed.listResults(context, null, null);
                if (results == null || results.size() < 1) {
                    log.info((Object)"No earlier results found.");
                } else {
                    int i = 0;
                    int len = results.size();
                    log.info((Object)(len + " results found."));
                    if (len > this.getMaxFetchResults()) {
                        len = this.getMaxFetchResults();
                        log.info((Object)("Fetching only " + len + " results."));
                    }
                    for (Object resultStub : results) {
                        double minFitness;
                        IGPProgram best;
                        JGAPResultGP result;
                        block19: {
                            if (i >= this.m_max_fetch_results) break block18;
                            feedback.setProgressValue(i);
                            result = this.receiveWorkResult(resultStub, feedback, false);
                            if (result == null) continue;
                            log.info((Object)(" Generic data: " + result.getGenericData()));
                            log.info((Object)(" Title: " + result.getTitle()));
                            best = result.getPopulation().determineFittestProgram();
                            String key = result.getID();
                            if (this.m_objects.getResults().get(key) != null) {
                                log.info((Object)("Already received result detected, key: " + key));
                                continue;
                            }
                            if (best == null) {
                                log.info((Object)"Empty result received!");
                            }
                            this.m_objects.getResults().put(key, "received");
                            this.m_gridConfig.getClientEvolveStrategy().resultReceived(result);
                            try {
                                try {
                                    log.info((Object)"Removing result from online store");
                                    this.m_gcmed.removeMessage(resultStub);
                                }
                                catch (Exception ex) {
                                    log.warn((Object)"Deletion of result failed, deferring...", (Throwable)ex);
                                    key = this.getKeyFromObject(resultStub);
                                    if (key != null) {
                                        log.info((Object)(" Key for later deletion: " + key));
                                        this.m_objects.getResults().put(key, "delete:");
                                        break block19;
                                    }
                                    log.info((Object)"Deferred deletion not possible: key unknown");
                                }
                            }
                            finally {
                                this.m_persister.save();
                            }
                        }
                        ++i;
                        this.resultReceived(best);
                        MasterInfo worker = result.getWorkerInfo();
                        if (worker != null) {
                            log.info((Object)(" Worker IP " + worker.m_IPAddress + ", host " + worker.m_name));
                        }
                        if ((minFitness = this.m_gridConfig.getMinFitnessToStore()) < 1.0E-4) {
                            minFitness = 5000.0;
                        }
                        if (best == null || !(best.getFitnessValue() >= minFitness)) continue;
                        String filename = this.getResultFilename(result);
                        log.info((Object)("Writing result to file " + filename));
                        this.writeToFile(best, this.m_workDir, filename);
                    }
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    feedback.setProgressValue(i + workList.length);
                    this.receiveWorkResult(workList, feedback);
                    if (!this.isInterrupted() && !this.m_gridConfig.getClientEvolveStrategy().isEvolutionFinished(0)) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    protected String getResultFilename(JGAPResultGP a_result) {
        IGPProgram fittest = WANUtils.getFittest(a_result);
        String fitness = "";
        if (fittest == null) {
            log.error((Object)"No fittest program found!");
        } else {
            fitness = NumberKit.niceDecimalNumber(fittest.getFitnessValue(), 2);
        }
        return "result_" + fitness + "_" + this.getRunID() + "_" + a_result.getID() + "_" + a_result.getSessionName() + "_" + a_result.getChunk() + ".jgap";
    }

    private JGAPResultGP receiveWorkResult(Object a_result, IClientFeedbackGP feedback, boolean a_remove) throws Exception {
        MessageContext context = new MessageContext(MODULE_WS, CONTEXT_WORK_RESULT, a_result);
        GridMessageWorkResult gmwr = (GridMessageWorkResult)this.m_gcmed.getGridMessage(context, null, 20, 5, a_remove);
        if (gmwr == null) {
            throw new WorkResultNotFoundException();
        }
        String s = " ";
        if (a_remove) {
            s = s + "and removed from WAN";
        }
        log.info((Object)("Work result received" + s));
        JGAPResultGP workResult = (JGAPResultGP)gmwr.getWorkResult();
        int idx = workResult.getChunk();
        feedback.receivedFragmentResult(null, workResult, idx);
        return workResult;
    }

    private JGAPResultGP receiveWorkResult(JGAPRequestGP[] workList, IClientFeedbackGP feedback) throws Exception {
        MessageContext context = new MessageContext(MODULE_WS, CONTEXT_WORK_RESULT, CONTEXT_ID_EMPTY);
        GridMessageWorkResult gmwr = (GridMessageWorkResult)this.m_gcmed.getGridMessage(context, null, 20, 5, true);
        if (gmwr == null) {
            throw new NoWorkResultsFoundException();
        }
        log.info((Object)"Work result received!");
        JGAPResultGP workResult = (JGAPResultGP)gmwr.getWorkResult();
        this.m_gridConfig.getClientEvolveStrategy().resultReceived(workResult);
        int idx = workResult.getChunk();
        JGAPRequestGP req = workList == null || workList.length < 1 ? null : workList[idx];
        feedback.receivedFragmentResult(req, workResult, idx);
        IGPProgram best = workResult.getFittest();
        if (best == null) {
            best = workResult.getPopulation().determineFittestProgram();
        }
        this.resultReceived(best);
        return workResult;
    }

    protected void evolve(IGridClientMediator a_gcmed, boolean a_receiveOnly) throws Exception {
        IClientFeedbackGP feedback = this.m_gridConfig.getClientFeedback();
        feedback.beginWork();
        IClientEvolveStrategyGP evolver = this.m_gridConfig.getClientEvolveStrategy();
        IRequestSplitStrategyGP splitter = this.m_gridConfig.getRequestSplitStrategy();
        int evolutionIndex = 0;
        while (true) {
            JGAPRequestGP[] workRequests = null;
            boolean deferRequests = false;
            if (!a_receiveOnly) {
                try {
                    long lastListing = this.m_objects.getLastListingRequestsMillis();
                    long current = System.currentTimeMillis();
                    if (current - lastListing > 3600L) {
                        MessageContext context = new MessageContext(MODULE_CS, CONTEXT_WORK_REQUEST, CONTEXT_ID_EMPTY);
                        List requests = a_gcmed.listRequests(context, null, null);
                        this.m_objects.setLastListingRequestsMillis(current);
                        this.m_persister.save();
                        if (requests != null && requests.size() > 100) {
                            deferRequests = true;
                            log.info((Object)("Deferring creating and sending further requests, maximum reached (" + requests.size() + " found)."));
                        }
                        if (requests != null && requests.size() > 0) {
                            HashMap<Object, String> foundKeys = new HashMap<Object, String>();
                            Object first = requests.get(0);
                            if (String.class.isAssignableFrom(first.getClass())) {
                                for (Object key : requests) {
                                    foundKeys.put(key, "");
                                }
                            } else {
                                for (Object obj : requests) {
                                    String key = this.getKeyFromObject(obj);
                                    if (key == null) continue;
                                    foundKeys.put(key, "");
                                }
                            }
                            this.removeEntries(foundKeys, this.m_objects.getRequests());
                        }
                    }
                    if (!deferRequests) {
                        workRequests = this.sendWorkRequests(evolutionIndex, evolver, splitter, feedback);
                    }
                }
                catch (WorkRequestsSendException wex) {
                    this.errorOnSendWorkRequests(wex.getCause(), wex.getWorkRequests());
                }
                if (!deferRequests && !this.afterSendWorkRequests(workRequests)) break;
            }
            if (this.isInterrupted()) break;
            if (!deferRequests && !a_receiveOnly) {
                evolver.afterWorkRequestsSent();
            }
            if (!this.m_no_comm) {
                try {
                    this.receiveWorkResults(workRequests);
                }
                catch (Exception ex) {
                    this.onErrorReceiveWorkResults(workRequests, ex);
                }
            }
            if (!a_receiveOnly && !this.m_no_evolution) {
                evolver.evolve();
                feedback.completeFrame(evolutionIndex);
                if (!evolver.isEvolutionFinished(++evolutionIndex)) continue;
                evolver.onFinished();
                break;
            }
            a_gcmed.disconnect();
            log.info((Object)"Sleeping a while before beginning again...");
            Thread.sleep(40000L);
            a_gcmed.connect();
        }
        try {
            a_gcmed.disconnect();
        }
        catch (Exception ex) {
            log.error((Object)"Disconnecting from server failed!", (Throwable)ex);
        }
        this.m_gridConfig.getClientFeedback().endWork();
    }

    public void start() {
        try {
            this.m_gridConfig.validate();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        super.start();
    }

    public GPConfiguration getConfiguration() {
        return this.m_gridConfig.getConfiguration();
    }

    public IGridClientMediator getGridClientMediator() {
        return this.m_gcmed;
    }

    protected IGridConfigurationGP getGridConfigurationGP() {
        return this.m_gridConfig;
    }

    public void writeToFile(Object a_obj, String a_dir, String a_filename) throws Exception {
        JGAPGPXStream xstream = new JGAPGPXStream();
        File f = new File(a_dir, a_filename);
        FileWriter fw = new FileWriter(f);
        CompactWriter compact = new CompactWriter((Writer)fw);
        xstream.marshal(a_obj, (HierarchicalStreamWriter)compact);
        fw.close();
    }

    public void setWorkDirectory(String a_workDir) throws IOException {
        this.m_workDir = a_workDir;
        FileKit.createDirectory(this.m_workDir);
        log.info((Object)("Work dir: " + this.m_workDir));
    }

    public String getWorkDirectory() {
        return this.m_workDir;
    }

    protected void checkForUpdates(String a_URL, String a_libDir, String a_workDir) throws Exception {
        GridKit.updateModuleLibrary(a_URL, "rjgrid", a_libDir, a_workDir);
    }

    protected void listRequests() {
    }

    protected void listResults() {
    }

    public boolean isNoCommunication() {
        return this.m_no_comm;
    }

    public static void main(String[] args) {
        try {
            MainCmd.setUpLog4J((String)"client", (boolean)true);
            GridNodeClientConfig config = new GridNodeClientConfig();
            Options options = JGAPClientGP.makeOptions();
            CommandLine cmd = MainCmd.parseCommonOptions((Options)options, (GridNodeConfig)config, (String[])args);
            SystemKit.printHelp(cmd, options);
            String networkMode = cmd.getOptionValue("l", "LAN");
            boolean inWAN = networkMode == null || !networkMode.equals("LAN");
            if (!cmd.hasOption("config")) {
                System.out.println("Please provide a name of the grid configuration class to use");
                System.out.println("An example class would be examples.grid.fitnessDistributed.GridConfiguration");
                System.exit(1);
            }
            String clientClassName = cmd.getOptionValue("config");
            boolean receiveOnly = cmd.hasOption("receive_only");
            boolean list = cmd.hasOption("list");
            boolean noComm = cmd.hasOption("no_comm");
            boolean noEvolution = cmd.hasOption("no_evolution");
            boolean endless = cmd.hasOption("endless");
            int max_fetch_results = Integer.valueOf(cmd.getOptionValue("max_fetch_results", CONTEXT_ID_EMPTY));
            JGAPClientGP client = new JGAPClientGP(config, clientClassName, inWAN, receiveOnly, list, noComm, noEvolution, endless, max_fetch_results);
            client.start();
            client.join();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(1);
        }
    }

    protected static Options makeOptions() {
        Options options = new Options();
        options.addOption("l", true, "LAN or WAN");
        options.addOption("no_comm", false, "Don't receive any results, don't send requests");
        options.addOption("no_evolution", false, "Don't perform genetic evolution");
        options.addOption("receive_only", false, "Only receive results, don't send requests");
        options.addOption("endless", false, "Run endlessly");
        options.addOption("config", true, "Grid configuration's class name");
        options.addOption("list", false, "List requests and results");
        options.addOption("max_fetch_results", true, "Maximum number of results to fetch at once");
        options.addOption("help", false, "Display all available options");
        return options;
    }

    protected void removeEntries(Map a_cachedKeys, Map a_foundKeys) {
        Iterator it = a_cachedKeys.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            if (a_foundKeys.containsKey(key)) continue;
            it.remove();
        }
    }

    protected String getKeyFromObject(Object a_obj) throws Exception {
        return null;
    }

    protected boolean resultReceived(GPPopulation a_pop) throws Exception {
        boolean isTopResult = false;
        for (IGPProgram prog : a_pop.getGPPrograms()) {
            if (prog == null || !this.resultReceived(prog)) continue;
            isTopResult = true;
        }
        return isTopResult;
    }

    protected boolean resultReceived(IGPProgram a_fittest) throws Exception {
        if (a_fittest == null) {
            return false;
        }
        try {
            String title;
            Map topAll = this.m_objects.getTopResults();
            String appid = this.m_gridConfig.getContext().getAppId();
            Vector<IGPProgram> topApp = (Vector<IGPProgram>)topAll.get(appid);
            if (topApp == null) {
                topApp = new Vector<IGPProgram>();
                topAll.put(appid, topApp);
            }
            int fitter = 0;
            Iterator it = topApp.iterator();
            IGPProgram worstEntry = null;
            double worstFitness = -1.0;
            String norm = a_fittest.toStringNorm(0);
            int count = 0;
            double a_fitness = a_fittest.getFitnessValue();
            if (a_fitness > 12500.0) {
                log.info((Object)"Backup up good result");
                title = "fitness_" + NumberKit.niceDecimalNumber(a_fitness, 2);
                this.m_gcmed.backupResult(a_fittest, "goodResults", title);
            } else if (a_fitness > 1750.0) {
                log.info((Object)"Storing not too bad result for later reusage");
                title = "ntb_fitness_" + DateKit.getNowAsString() + "_" + NumberKit.niceDecimalNumber(a_fitness, 2) + ".jgap";
                this.saveResult(this.m_ntbResultsDir, title, a_fittest);
            }
            while (it.hasNext()) {
                IGPProgram prog = (IGPProgram)it.next();
                if (prog.toStringNorm(0).equals(norm)) {
                    fitter = 100;
                    break;
                }
                double fitness = prog.getFitnessValue();
                if (Math.abs(fitness - a_fittest.getFitnessValue()) < 0.001) {
                    fitter = 100;
                    break;
                }
                if (fitness >= a_fitness) {
                    ++fitter;
                }
                if (worstEntry == null || this.getConfiguration().getGPFitnessEvaluator().isFitter(worstFitness, fitness)) {
                    worstEntry = prog;
                    worstFitness = fitness;
                }
                ++count;
            }
            boolean result = true;
            if (fitter < 3 || count > 3) {
                if (worstEntry != null && count >= 3 && !topApp.remove(worstEntry)) {
                    log.error((Object)"Removing of worst entry failed");
                }
                if (fitter < 3) {
                    try {
                        GPGenotype.checkErroneousProg(a_fittest, " add top fit", true, false);
                    }
                    catch (Throwable t) {
                        log.warn((Object)"Received program not valid!");
                        result = false;
                    }
                    if (result) {
                        a_fitness = a_fittest.getFitnessValue();
                        if (a_fitness < 1000.0) {
                            result = false;
                        } else {
                            topApp.add(a_fittest);
                            log.info((Object)("Added fit program, fitness: " + NumberKit.niceDecimalNumber(a_fitness, 2)));
                            log.info((Object)("Solution: " + a_fittest.toStringNorm(0)));
                            result = true;
                        }
                    }
                } else {
                    log.info((Object)"Result not better than top results received, removed obsolete top result");
                    result = false;
                }
            } else {
                log.info((Object)"Result not better than top results received");
                result = false;
            }
            if (result) {
                this.m_persister.save();
            }
            return result;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    protected void saveResult(String a_dir, String a_filename, IGPProgram a_obj) throws Exception {
        String filename = FileKit.addFilename(a_dir, a_filename);
        PersistableObject po = new PersistableObject(filename);
        po.setObject(a_obj);
        po.save();
    }

    public String[] getFilenames(String a_dir) throws Exception {
        String[] files = FileKit.listFilesInDir(a_dir, null);
        return files;
    }

    protected void presetPopulation(JGAPRequestGP a_workRequest) throws Exception {
        RandomGenerator randGen = this.getConfiguration().getRandomGenerator();
        double d = randGen.nextDouble();
        if (d > 0.15) {
            int len;
            int count;
            String[] results;
            Map topAll = this.m_objects.getTopResults();
            String appid = this.m_gridConfig.getContext().getAppId();
            List topApp = (List)topAll.get(appid);
            int added = 0;
            GPPopulation pop = a_workRequest.getPopulation();
            IGPProgram[] programs = pop.getGPPrograms();
            Vector<IGPProgram> toAdd = new Vector<IGPProgram>();
            if (topApp != null && topApp.size() > 0) {
                for (IGPProgram prog : topApp) {
                    GPGenotype.checkErroneousProg(prog, " before add preset", true);
                    toAdd.add(prog);
                    if (++added < 3 && !(randGen.nextDouble() > 0.6)) continue;
                    break;
                }
            }
            if ((results = this.getFilenames(this.m_ntbResultsDir)) != null && results.length > 0 && (count = randGen.nextInt(Math.min(5, results.length))) > 0) {
                if (count > results.length) {
                    count = results.length;
                }
                for (int i = 0; i < count; ++i) {
                    int index = randGen.nextInt(results.length);
                    String filename = FileKit.addFilename(this.m_ntbResultsDir, results[index]);
                    PersistableObject po = new PersistableObject(filename);
                    IGPProgram ntb = (IGPProgram)po.load();
                    log.info((Object)"Presetting with NTB result");
                    ++added;
                    toAdd.add(ntb);
                }
            }
            if ((len = programs.length) > 0) {
                for (len = 0; len < programs.length && programs[len] != null; ++len) {
                }
                IGPProgram[] programsNew = toAdd.toArray(new IGPProgram[0]);
                int size = len + toAdd.size();
                IGPProgram[] allPrograms = new IGPProgram[size];
                if (len > 0) {
                    System.arraycopy(programs, 0, allPrograms, 0, len);
                }
                System.arraycopy(programsNew, 0, allPrograms, len, programsNew.length);
                pop.setGPPrograms(allPrograms);
                log.info((Object)("Population preset with " + added + " additional programs"));
            }
        }
    }

    protected void showCurrentResults() throws Exception {
        String appid = this.m_gridConfig.getContext().getAppId();
        Map topAll = this.m_objects.getTopResults();
        List topApp = (List)topAll.get(appid);
        if (topApp != null && topApp.size() > 0) {
            log.info((Object)"Top evolved results yet:");
            log.info((Object)"------------------------");
            boolean changed = false;
            Iterator it = topApp.iterator();
            while (it.hasNext()) {
                IGPProgram prog = (IGPProgram)it.next();
                try {
                    GPGenotype.checkErroneousProg(prog, " as top result", false, true);
                }
                catch (Throwable t) {
                    it.remove();
                    changed = true;
                    continue;
                }
                double fitness = prog.getFitnessValue();
                log.info((Object)("Fitness " + NumberKit.niceDecimalNumber(fitness, 2)));
                if (!(fitness < 1000.0)) continue;
                log.info((Object)("Removing too bad result with fitness " + NumberKit.niceDecimalNumber(fitness, 2)));
                it.remove();
                changed = true;
            }
            if (changed) {
                this.m_persister.save();
            }
            log.info((Object)"");
        } else {
            log.info((Object)"No top results yet.");
        }
    }

    public int getMaxFetchResults() {
        return this.m_max_fetch_results;
    }

    private boolean startsWith(String s, String a_prefix) {
        if (s == null || a_prefix == null) {
            return false;
        }
        return s.startsWith(a_prefix);
    }
}

