/*
 * Decompiled with CFR 0.152.
 */
package weka.gui.explorer;

import java.util.ArrayList;
import weka.clusterers.ClusterEvaluation;
import weka.clusterers.Clusterer;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instances;
import weka.core.Utils;
import weka.gui.explorer.AbstractPlotInstances;
import weka.gui.visualize.PlotData2D;

public class ClustererAssignmentsPlotInstances
extends AbstractPlotInstances {
    private static final long serialVersionUID = -4748134272046520423L;
    protected int[] m_PlotShapes;
    protected Clusterer m_Clusterer;
    protected ClusterEvaluation m_Evaluation;

    @Override
    protected void initialize() {
        super.initialize();
        this.m_PlotShapes = null;
        this.m_Clusterer = null;
        this.m_Evaluation = null;
    }

    public void setClusterer(Clusterer value) {
        this.m_Clusterer = value;
    }

    public Clusterer getClusterer() {
        return this.m_Clusterer;
    }

    public void setClusterEvaluation(ClusterEvaluation value) {
        this.m_Evaluation = value;
    }

    public ClusterEvaluation getClusterEvaluation() {
        return this.m_Evaluation;
    }

    @Override
    protected void check() {
        super.check();
        if (this.m_Clusterer == null) {
            throw new IllegalStateException("No clusterer set!");
        }
        if (this.m_Evaluation == null) {
            throw new IllegalStateException("No cluster evaluation set!");
        }
    }

    @Override
    protected void determineFormat() {
        int numClusters = this.m_Evaluation.getNumClusters();
        ArrayList<Attribute> hv = new ArrayList<Attribute>();
        ArrayList<String> clustVals = new ArrayList<String>();
        int i = 0;
        while (i < numClusters) {
            clustVals.add("cluster" + i);
            ++i;
        }
        Attribute predictedCluster = new Attribute("Cluster", clustVals);
        i = 0;
        while (i < this.m_Instances.numAttributes()) {
            hv.add((Attribute)this.m_Instances.attribute(i).copy());
            ++i;
        }
        hv.add(predictedCluster);
        this.m_PlotInstances = new Instances(String.valueOf(this.m_Instances.relationName()) + "_clustered", hv, this.m_Instances.numInstances());
    }

    protected void process() {
        int i;
        double[] clusterAssignments = this.m_Evaluation.getClusterAssignments();
        int[] classAssignments = null;
        if (this.m_Instances.classIndex() >= 0) {
            classAssignments = this.m_Evaluation.getClassesToClusters();
            this.m_PlotShapes = new int[this.m_Instances.numInstances()];
            i = 0;
            while (i < this.m_Instances.numInstances()) {
                this.m_PlotShapes[i] = -1;
                ++i;
            }
        }
        i = 0;
        while (i < this.m_Instances.numInstances()) {
            double[] values = new double[this.m_PlotInstances.numAttributes()];
            int j = 0;
            while (j < this.m_Instances.numAttributes()) {
                values[j] = this.m_Instances.instance(i).value(j);
                ++j;
            }
            values[j] = clusterAssignments[i] < 0.0 ? Utils.missingValue() : clusterAssignments[i];
            this.m_PlotInstances.add(new DenseInstance(1.0, values));
            if (this.m_PlotShapes != null) {
                if (clusterAssignments[i] >= 0.0) {
                    if ((int)this.m_Instances.instance(i).classValue() != classAssignments[(int)clusterAssignments[i]]) {
                        this.m_PlotShapes[i] = 1000;
                    }
                } else {
                    this.m_PlotShapes[i] = 2000;
                }
            }
            ++i;
        }
    }

    @Override
    protected void finishUp() {
        super.finishUp();
        this.process();
    }

    @Override
    protected PlotData2D createPlotData(String name) throws Exception {
        PlotData2D result = new PlotData2D(this.m_PlotInstances);
        if (this.m_PlotShapes != null) {
            result.setShapeType(this.m_PlotShapes);
        }
        result.addInstanceNumberAttribute();
        result.setPlotName(String.valueOf(name) + " (" + this.m_Instances.relationName() + ")");
        return result;
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_Clusterer = null;
        this.m_Evaluation = null;
        this.m_PlotShapes = null;
    }
}

