/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.internal.operations;

import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.uml2.uml.Expression;
import org.eclipse.uml2.uml.Message;
import org.eclipse.uml2.uml.MessageKind;
import org.eclipse.uml2.uml.MessageSort;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.uml2.uml.internal.operations.NamedElementOperations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageOperations
extends NamedElementOperations {
    protected MessageOperations() {
    }

    public static boolean validateSendingReceivingMessageEvent(Message message, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateSignatureReferTo(Message message, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateSignatureIsOperationRequest(Message message, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateSignatureIsOperationReply(Message message, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateSignatureIsSignal(Message message, DiagnosticChain diagnostics, Map<Object, Object> context) {
        EList<ValueSpecification> arguments;
        NamedElement signature;
        boolean result = true;
        if (message.getMessageSort() == MessageSort.ASYNCH_SIGNAL_LITERAL && (signature = message.getSignature()) instanceof Signal && !(arguments = message.getArguments()).isEmpty()) {
            UniqueEList.FastCompare<Property> signalAttributes = new UniqueEList.FastCompare<Property>();
            for (NamedElement n : ((Signal)signature).getInheritedMembers()) {
                if (!(n instanceof Property)) continue;
                signalAttributes.add((Property)n);
            }
            if (arguments.size() != signalAttributes.size()) {
                result = false;
            } else {
                for (ValueSpecification o : arguments) {
                    if (o instanceof Expression && MessageOperations.isEmpty(((Expression)o).getSymbol()) && ((Expression)o).getOperands().isEmpty()) continue;
                    Type oType = o.getType();
                    Type pType = ((Property)signalAttributes.get(arguments.indexOf(o))).getType();
                    if (!(oType == null ? pType != null : !oType.conformsTo(pType))) continue;
                    result = false;
                    break;
                }
            }
        }
        if (!result && diagnostics != null) {
            diagnostics.add(new BasicDiagnostic(2, "org.eclipse.uml2.uml", 380, UMLPlugin.INSTANCE.getString("_UI_Message_SignatureIsSignal_diagnostic", MessageOperations.getMessageSubstitutions(context, message)), new Object[]{message}));
        }
        return result;
    }

    public static boolean validateArguments(Message message, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateCannotCrossBoundaries(Message message, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static boolean validateOccurrenceSpecifications(Message message, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public static MessageKind getMessageKind(Message message) {
        return message.eGet(UMLPackage.Literals.MESSAGE__SEND_EVENT, false) == null ? (message.eGet(UMLPackage.Literals.MESSAGE__RECEIVE_EVENT, false) == null ? MessageKind.UNKNOWN_LITERAL : MessageKind.FOUND_LITERAL) : (message.eGet(UMLPackage.Literals.MESSAGE__RECEIVE_EVENT, false) == null ? MessageKind.LOST_LITERAL : MessageKind.COMPLETE_LITERAL);
    }

    public static boolean isDistinguishableFrom(Message message, NamedElement n, Namespace ns) {
        return true;
    }
}

