/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.gp.function;

import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.function.ReadTerminal;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;

public class StoreTerminal
extends CommandGene
implements ICloneable {
    private static final String CVS_REVISION = "$Revision: 1.14 $";
    private String m_storageName;
    private Class m_type;

    public StoreTerminal(GPConfiguration a_conf, String a_storageName, Class a_childType) throws InvalidConfigurationException {
        this(a_conf, a_storageName, a_childType, 0, 0);
    }

    public StoreTerminal(GPConfiguration a_conf, String a_storageName, Class a_childType, int a_subReturnType, int a_subChildType) throws InvalidConfigurationException {
        super(a_conf, 1, CommandGene.VoidClass, a_subReturnType, new int[]{a_subChildType});
        this.m_type = a_childType;
        if (a_storageName == null || a_storageName.length() < 1) {
            throw new IllegalArgumentException("Memory name must not be empty!");
        }
        this.m_storageName = a_storageName;
    }

    public String toString() {
        return "store(" + this.m_storageName + ", &1)";
    }

    public String getName() {
        return "Store Terminal(" + this.m_storageName + ")";
    }

    public void execute_void(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        Object value = null;
        value = this.m_type == CommandGene.IntegerClass ? new Integer(c.execute_int(n, 0, args)) : (this.m_type == CommandGene.LongClass ? new Long(c.execute_long(n, 0, args)) : (this.m_type == CommandGene.DoubleClass ? new Double(c.execute_double(n, 0, args)) : (this.m_type == CommandGene.FloatClass ? new Float(c.execute_float(n, 0, args)) : c.execute(n, 0, args))));
        this.getGPConfiguration().storeInMemory(this.m_storageName, value);
    }

    public int execute_int(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        int value = c.execute_int(n, 0, args);
        this.getGPConfiguration().storeInMemory(this.m_storageName, new Integer(value));
        return value;
    }

    public long execute_long(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        long value = c.execute_long(n, 0, args);
        this.getGPConfiguration().storeInMemory(this.m_storageName, new Long(value));
        return value;
    }

    public double execute_double(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        double value = c.execute_double(n, 0, args);
        this.getGPConfiguration().storeInMemory(this.m_storageName, new Double(value));
        return value;
    }

    public float execute_float(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        float value = c.execute_float(n, 0, args);
        this.getGPConfiguration().storeInMemory(this.m_storageName, new Float(value));
        return value;
    }

    public Object execute_object(ProgramChromosome c, int n, Object[] args) {
        this.check(c);
        Object value = c.execute_object(n, 0, args);
        this.getGPConfiguration().storeInMemory(this.m_storageName, value);
        return value;
    }

    public boolean isAffectGlobalState() {
        return true;
    }

    public boolean isValid(ProgramChromosome a_program) {
        return a_program.getIndividual().getCommandOfClass(0, ReadTerminal.class) > 0;
    }

    public Class getChildType(IGPProgram a_ind, int a_chromNum) {
        return this.m_type;
    }

    public int compareTo(Object a_other) {
        int result = super.compareTo(a_other);
        if (result != 0) {
            return result;
        }
        StoreTerminal other = (StoreTerminal)a_other;
        return new CompareToBuilder().append((Object)this.m_storageName, (Object)other.m_storageName).append((Object)this.m_type, (Object)other.m_type).toComparison();
    }

    public boolean equals(Object a_other) {
        try {
            StoreTerminal other = (StoreTerminal)a_other;
            return super.equals(a_other) && new EqualsBuilder().append((Object)this.m_storageName, (Object)other.m_storageName).append((Object)this.m_type, (Object)other.m_type).isEquals();
        }
        catch (ClassCastException cex) {
            return false;
        }
    }

    public Object clone() {
        try {
            StoreTerminal result = new StoreTerminal(this.getGPConfiguration(), this.m_storageName, this.m_type, this.getSubReturnType(), this.getSubChildType(0));
            return result;
        }
        catch (Exception ex) {
            throw new CloneException(ex);
        }
    }
}

