/*
 * Decompiled with CFR 0.152.
 */
package org.jgap.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.UUID;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.jgap.util.StringKit;

public class SystemKit {
    private static final String CVS_REVISION = "$Revision: 1.9 $";

    public static double getTotalMemoryMB() {
        return SystemKit.getTotalMemoryKB() / 1024.0;
    }

    public static double getTotalMemoryKB() {
        return Runtime.getRuntime().totalMemory() / 1024L;
    }

    public static double getFreeMemoryMB() {
        return SystemKit.getFreeMemoryKB() / 1024.0;
    }

    public static double getFreeMemoryKB() {
        return Runtime.getRuntime().freeMemory() / 1024L;
    }

    public static String niceMemory(double a_mem) {
        String freeMB = "" + a_mem;
        int index = freeMB.indexOf(46);
        int len = freeMB.length();
        if (len - index > 2) {
            freeMB = freeMB.substring(0, index + 2);
        }
        return freeMB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getFirstLineOfCommand(String[] commands) throws IOException {
        Process p = null;
        BufferedReader reader = null;
        try {
            p = Runtime.getRuntime().exec(commands);
            reader = new BufferedReader(new InputStreamReader(p.getInputStream()), 128);
            String string = reader.readLine();
            return string;
        }
        finally {
            if (p != null) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {}
                }
                try {
                    p.getErrorStream().close();
                }
                catch (IOException ex) {}
                try {
                    p.getOutputStream().close();
                }
                catch (IOException ex) {}
                p.destroy();
            }
        }
    }

    public static void printHelp(CommandLine cmd, Options options) {
        if (cmd.hasOption("help")) {
            System.out.println("");
            System.out.println(" Command line options:");
            System.out.println(" ---------------------");
            for (Object opt0 : options.getOptions()) {
                Option opt = (Option)opt0;
                String s = opt.getOpt();
                s = StringKit.fill(s, 20, ' ');
                System.out.println(" " + s + " - " + opt.getDescription());
            }
            System.exit(0);
        }
    }

    public static String getGUID() {
        return UUID.randomUUID().toString();
    }
}

