/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization;

import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.AbstractKMeansInitialization;
import de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.initialization.KMedoidsInitialization;
import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDVar;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.query.distance.DistanceQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.NumberVectorDistanceFunction;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

@Reference(authors="D. Arthur, S. Vassilvitskii", title="k-means++: the advantages of careful seeding", booktitle="Proc. of the Eighteenth Annual ACM-SIAM Symposium on Discrete Algorithms, SODA 2007", url="http://dx.doi.org/10.1145/1283383.1283494")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.clustering.kmeans.KMeansPlusPlusInitialMeans"})
public class KMeansPlusPlusInitialMeans<O>
extends AbstractKMeansInitialization<NumberVector>
implements KMedoidsInitialization<O> {
    public KMeansPlusPlusInitialMeans(RandomFactory randomFactory) {
        super(randomFactory);
    }

    @Override
    public <T extends NumberVector, V extends NumberVector> List<V> chooseInitialMeans(Database database, Relation<T> relation, int n, NumberVectorDistanceFunction<? super T> numberVectorDistanceFunction, NumberVector.Factory<V> factory) {
        DistanceQuery<? super T> distanceQuery = database.getDistanceQuery(relation, numberVectorDistanceFunction, new Object[0]);
        DBIDs dBIDs = relation.getDBIDs();
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 3, 0.0);
        ArrayList<V> arrayList = new ArrayList<V>(n);
        if (dBIDs.size() <= n) {
            throw new AbortException("Don't use k-means with k >= data set size.");
        }
        Random random = this.rnd.getSingleThreadedRandom();
        DBIDVar dBIDVar = DBIDUtil.randomSample(dBIDs, random);
        NumberVector numberVector = (NumberVector)relation.get(dBIDVar);
        arrayList.add(factory.newNumberVector(numberVector));
        double d = this.initialWeights(writableDoubleDataStore, dBIDs, numberVector, distanceQuery);
        while (true) {
            double d2;
            if (d > Double.MAX_VALUE) {
                LoggingUtil.warning("Could not choose a reasonable mean for k-means++ - too many data points, too large squared distances?");
            }
            if (d < Double.MIN_NORMAL) {
                LoggingUtil.warning("Could not choose a reasonable mean for k-means++ - to few data points?");
            }
            double d3 = random.nextDouble() * d;
            DBIDIter dBIDIter = dBIDs.iter();
            for (d2 = 0.0; d2 < d3 && dBIDIter.valid(); d2 += writableDoubleDataStore.doubleValue(dBIDIter)) {
                dBIDIter.advance();
            }
            if (!dBIDIter.valid()) {
                d -= d3 - d2;
                continue;
            }
            NumberVector numberVector2 = (NumberVector)relation.get(dBIDIter);
            arrayList.add(factory.newNumberVector(numberVector2));
            if (arrayList.size() >= n) break;
            writableDoubleDataStore.putDouble(dBIDIter, 0.0);
            d = this.updateWeights(writableDoubleDataStore, dBIDs, numberVector2, distanceQuery);
        }
        writableDoubleDataStore.destroy();
        return arrayList;
    }

    @Override
    public DBIDs chooseInitialMedoids(int n, DBIDs dBIDs, DistanceQuery<? super O> distanceQuery) {
        Relation<O> relation = distanceQuery.getRelation();
        ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(n);
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(dBIDs, 3, 0.0);
        Random random = this.rnd.getSingleThreadedRandom();
        DBIDVar dBIDVar = DBIDUtil.randomSample(dBIDs, random);
        arrayModifiableDBIDs.add(dBIDVar);
        double d = this.initialWeights(writableDoubleDataStore, dBIDs, relation.get(dBIDVar), distanceQuery);
        while (true) {
            if (d > Double.MAX_VALUE) {
                LoggingUtil.warning("Could not choose a reasonable mean for k-means++ - too many data points, too large squared distances?");
            }
            if (d < Double.MIN_NORMAL) {
                LoggingUtil.warning("Could not choose a reasonable mean for k-means++ - to few unique data points?");
            }
            double d2 = random.nextDouble() * d;
            while (d2 <= 0.0 && d > Double.MIN_NORMAL) {
                d2 = random.nextDouble() * d;
            }
            DBIDIter dBIDIter = dBIDs.iter();
            while (d2 > 0.0 && dBIDIter.valid()) {
                d2 -= writableDoubleDataStore.doubleValue(dBIDIter);
                dBIDIter.advance();
            }
            arrayModifiableDBIDs.add(dBIDIter);
            if (arrayModifiableDBIDs.size() >= n) break;
            writableDoubleDataStore.putDouble(dBIDIter, 0.0);
            d = this.updateWeights(writableDoubleDataStore, dBIDs, relation.get(dBIDIter), distanceQuery);
        }
        return arrayModifiableDBIDs;
    }

    protected <T> double initialWeights(WritableDoubleDataStore writableDoubleDataStore, DBIDs dBIDs, T t, DistanceQuery<? super T> distanceQuery) {
        double d = 0.0;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            double d2 = distanceQuery.distance(t, (T)dBIDIter);
            writableDoubleDataStore.putDouble(dBIDIter, d2);
            d += d2;
            dBIDIter.advance();
        }
        return d;
    }

    protected <T> double updateWeights(WritableDoubleDataStore writableDoubleDataStore, DBIDs dBIDs, T t, DistanceQuery<? super T> distanceQuery) {
        double d = 0.0;
        DBIDIter dBIDIter = dBIDs.iter();
        while (dBIDIter.valid()) {
            double d2 = writableDoubleDataStore.doubleValue(dBIDIter);
            if (!(d2 <= 0.0)) {
                double d3 = distanceQuery.distance(t, (T)dBIDIter);
                if (d3 < d2) {
                    writableDoubleDataStore.putDouble(dBIDIter, d3);
                    d2 = d3;
                }
                d += d2;
            }
            dBIDIter.advance();
        }
        return d;
    }

    public static class Parameterizer<V>
    extends AbstractKMeansInitialization.Parameterizer {
        @Override
        protected KMeansPlusPlusInitialMeans<V> makeInstance() {
            return new KMeansPlusPlusInitialMeans(this.rnd);
        }
    }
}

