/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.itemsetmining;

import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.AbstractFrequentItemsetAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.DenseItemset;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.Itemset;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.OneItemset;
import de.lmu.ifi.dbs.elki.algorithm.itemsetmining.SparseItemset;
import de.lmu.ifi.dbs.elki.data.BitVector;
import de.lmu.ifi.dbs.elki.data.SparseFeatureVector;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.data.type.VectorFieldTypeInformation;
import de.lmu.ifi.dbs.elki.database.ids.ArrayModifiableDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.database.relation.RelationUtil;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.statistics.Duration;
import de.lmu.ifi.dbs.elki.logging.statistics.LongStatistic;
import de.lmu.ifi.dbs.elki.result.FrequentItemsetsResult;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.BitsUtil;
import de.lmu.ifi.dbs.elki.utilities.documentation.Description;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.documentation.Title;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import gnu.trove.iterator.TLongIntIterator;
import gnu.trove.map.hash.TLongIntHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Title(value="APRIORI: Algorithm for Mining Association Rules")
@Description(value="Searches for frequent itemsets")
@Reference(authors="R. Agrawal, R. Srikant", title="Fast Algorithms for Mining Association Rules", booktitle="Proc. 20th Int. Conf. on Very Large Data Bases (VLDB '94), Santiago de Chile, Chile 1994", url="http://www.vldb.org/conf/1994/P487.PDF")
@Alias(value={"de.lmu.ifi.dbs.elki.algorithm.APRIORI"})
public class APRIORI
extends AbstractFrequentItemsetAlgorithm {
    private static final Logging LOG = Logging.getLogger(APRIORI.class);
    private final String STAT = this.getClass().getName() + ".";

    public APRIORI(double d, int n, int n2) {
        super(d, n, n2);
    }

    public APRIORI(double d) {
        super(d);
    }

    public FrequentItemsetsResult run(Relation<BitVector> relation) {
        DBIDs dBIDs = relation.getDBIDs();
        ArrayList<Itemset> arrayList = new ArrayList<Itemset>();
        int n = dBIDs.size();
        int n2 = this.getMinimumSupport(n);
        VectorFieldTypeInformation<BitVector> vectorFieldTypeInformation = RelationUtil.assumeVectorField(relation);
        if (n > 0) {
            int n3 = vectorFieldTypeInformation.getDimensionality();
            Duration duration = LOG.newDuration(this.STAT + "1-items.time").begin();
            List<OneItemset> list = this.buildFrequentOneItemsets(relation, n3, n2);
            LOG.statistics(duration.end());
            if (LOG.isStatistics()) {
                LOG.statistics(new LongStatistic(this.STAT + "1-items.frequent", list.size()));
                LOG.statistics(new LongStatistic(this.STAT + "1-items.transactions", dBIDs.size()));
            }
            if (LOG.isDebuggingFine()) {
                LOG.debugFine(this.debugDumpCandidates(new StringBuilder(), list, vectorFieldTypeInformation));
            }
            if (this.minlength <= 1) {
                arrayList.addAll(list);
            }
            if (list.size() >= 2 && this.maxlength >= 2) {
                Duration duration2 = LOG.newDuration(this.STAT + "2-items.time").begin();
                ArrayModifiableDBIDs arrayModifiableDBIDs = DBIDUtil.newArray(dBIDs.size());
                List<Itemset> list2 = this.buildFrequentTwoItemsets(list, relation, n3, n2, dBIDs, arrayModifiableDBIDs);
                dBIDs = arrayModifiableDBIDs;
                LOG.statistics(duration2.end());
                if (LOG.isStatistics()) {
                    LOG.statistics(new LongStatistic(this.STAT + "2-items.frequent", list2.size()));
                    LOG.statistics(new LongStatistic(this.STAT + "2-items.transactions", dBIDs.size()));
                }
                if (LOG.isDebuggingFine()) {
                    LOG.debugFine(this.debugDumpCandidates(new StringBuilder(), list2, vectorFieldTypeInformation));
                }
                if (this.minlength <= 2) {
                    arrayList.addAll(list2);
                }
                for (int i = 3; i <= this.maxlength && list2.size() >= i; ++i) {
                    Duration duration3 = LOG.newDuration(this.STAT + i + "-items.time").begin();
                    list2 = this.aprioriGenerate(list2, i, n3);
                    if (LOG.isDebuggingFinest()) {
                        LOG.debugFinest(this.debugDumpCandidates(new StringBuilder().append("Before pruning: "), list2, vectorFieldTypeInformation));
                    }
                    arrayModifiableDBIDs = DBIDUtil.newArray(dBIDs.size());
                    list2 = this.frequentItemsets(list2, relation, n2, dBIDs, arrayModifiableDBIDs, i);
                    dBIDs = arrayModifiableDBIDs;
                    LOG.statistics(duration3.end());
                    if (LOG.isStatistics()) {
                        LOG.statistics(new LongStatistic(this.STAT + i + "-items.frequent", list2.size()));
                        LOG.statistics(new LongStatistic(this.STAT + i + "-items.transactions", dBIDs.size()));
                    }
                    if (LOG.isDebuggingFine()) {
                        LOG.debugFine(this.debugDumpCandidates(new StringBuilder(), list2, vectorFieldTypeInformation));
                    }
                    arrayList.addAll(list2);
                }
            }
        }
        return new FrequentItemsetsResult("APRIORI", "apriori", arrayList, vectorFieldTypeInformation);
    }

    protected List<OneItemset> buildFrequentOneItemsets(Relation<? extends SparseFeatureVector<?>> relation, int n, int n2) {
        int[] nArray = new int[n];
        Object object = relation.iterDBIDs();
        while (object.valid()) {
            SparseFeatureVector<?> sparseFeatureVector = relation.get((DBIDRef)object);
            int n3 = sparseFeatureVector.iter();
            while (sparseFeatureVector.iterValid(n3)) {
                int n4 = sparseFeatureVector.iterDim(n3);
                nArray[n4] = nArray[n4] + 1;
                n3 = sparseFeatureVector.iterAdvance(n3);
            }
            object.advance();
        }
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(this.STAT + "1-items.candidates", n));
        }
        object = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            if (nArray[i] < n2) continue;
            object.add(new OneItemset(i, nArray[i]));
        }
        return object;
    }

    protected List<SparseItemset> buildFrequentTwoItemsets(List<OneItemset> list, Relation<BitVector> relation, int n, int n2, DBIDs dBIDs, ArrayModifiableDBIDs arrayModifiableDBIDs) {
        int n3;
        int n4;
        int n5 = 0;
        long[] lArray = BitsUtil.zero(n);
        for (OneItemset object2 : list) {
            BitsUtil.setI(lArray, object2.item);
            ++n5;
        }
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(this.STAT + "2-items.candidates", (long)n5 * (long)(n5 - 1)));
        }
        TLongIntHashMap tLongIntHashMap = new TLongIntHashMap(n5 * (n5 - 1) >>> 1);
        long[] lArray2 = BitsUtil.zero(n);
        Object object = dBIDs.iter();
        while (object.valid()) {
            BitsUtil.setI(lArray2, lArray);
            relation.get((DBIDRef)object).andOnto(lArray2);
            int tLongIntIterator = 0;
            n4 = BitsUtil.nextSetBit(lArray2, 0);
            while (n4 >= 0) {
                n3 = BitsUtil.nextSetBit(lArray2, n4 + 1);
                while (n3 >= 0) {
                    long l = (long)n4 << 32 | (long)n3;
                    tLongIntHashMap.put(l, 1 + tLongIntHashMap.get(l));
                    ++tLongIntIterator;
                    n3 = BitsUtil.nextSetBit(lArray2, n3 + 1);
                }
                n4 = BitsUtil.nextSetBit(lArray2, n4 + 1);
            }
            if (tLongIntIterator > 2) {
                arrayModifiableDBIDs.add((DBIDRef)object);
            }
            object.advance();
        }
        object = new ArrayList(n5 * (int)Math.sqrt(n5));
        TLongIntIterator tLongIntIterator = tLongIntHashMap.iterator();
        while (tLongIntIterator.hasNext()) {
            tLongIntIterator.advance();
            if (tLongIntIterator.value() < n2) continue;
            n4 = (int)(tLongIntIterator.key() >>> 32);
            n3 = (int)(tLongIntIterator.key() & 0xFFFFFFFFFFFFFFFFL);
            object.add(new SparseItemset(new int[]{n4, n3}, tLongIntIterator.value()));
        }
        Collections.sort(object);
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(this.STAT + "2-items.frequent", object.size()));
        }
        return object;
    }

    protected List<Itemset> aprioriGenerate(List<? extends Itemset> list, int n, int n2) {
        if (list.size() < n) {
            return Collections.emptyList();
        }
        long l = 0L;
        int n3 = list.size();
        ArrayList<Itemset> arrayList = new ArrayList<Itemset>();
        Itemset itemset = list.get(0);
        if (itemset instanceof SparseItemset) {
            SparseItemset sparseItemset = new SparseItemset(new int[n - 1]);
            for (int i = 0; i < n3; ++i) {
                SparseItemset sparseItemset2;
                SparseItemset sparseItemset3 = (SparseItemset)list.get(i);
                block1: for (int j = i + 1; j < n3 && sparseItemset3.prefixTest(sparseItemset2 = (SparseItemset)list.get(j)); ++j) {
                    ++l;
                    System.arraycopy(sparseItemset3.indices, 1, sparseItemset.indices, 0, n - 2);
                    sparseItemset.indices[n - 2] = sparseItemset2.indices[n - 2];
                    for (int k = n - 3; k >= 0; --k) {
                        sparseItemset.indices[k] = sparseItemset3.indices[k + 1];
                        int n4 = Collections.binarySearch(list, sparseItemset);
                        if (n4 < 0) continue block1;
                    }
                    int[] nArray = new int[n];
                    System.arraycopy(sparseItemset3.indices, 0, nArray, 0, n - 1);
                    nArray[n - 1] = sparseItemset2.indices[n - 2];
                    arrayList.add(new SparseItemset(nArray));
                }
            }
        } else if (itemset instanceof DenseItemset) {
            DenseItemset denseItemset = new DenseItemset(BitsUtil.zero(n2), n - 1);
            block3: for (int i = 0; i < n3; ++i) {
                DenseItemset denseItemset2 = (DenseItemset)list.get(i);
                block4: for (int j = i + 1; j < n3; ++j) {
                    DenseItemset denseItemset3 = (DenseItemset)list.get(j);
                    System.arraycopy(denseItemset2.items, 0, denseItemset.items, 0, denseItemset2.items.length);
                    BitsUtil.xorI(denseItemset.items, denseItemset3.items);
                    if (BitsUtil.cardinality(denseItemset.items) != 2) continue block3;
                    ++l;
                    int n5 = BitsUtil.nextSetBit(denseItemset.items, 0);
                    if (BitsUtil.nextSetBit(denseItemset2.items, n5 + 1) > -1) continue block3;
                    BitsUtil.orI(denseItemset.items, denseItemset3.items);
                    int n6 = BitsUtil.nextSetBit(denseItemset.items, 0);
                    for (int k = n; k > 2; --k) {
                        BitsUtil.clearI(denseItemset.items, n6);
                        int n7 = Collections.binarySearch(list, denseItemset);
                        if (n7 < 0) continue block4;
                        BitsUtil.setI(denseItemset.items, n6);
                        n6 = BitsUtil.nextSetBit(denseItemset.items, n6 + 1);
                    }
                    arrayList.add(new DenseItemset((long[])denseItemset.items.clone(), n));
                }
            }
        } else {
            throw new AbortException("Unexpected itemset type " + itemset.getClass());
        }
        if (LOG.isStatistics()) {
            LOG.statistics(new LongStatistic(this.STAT + n + "-items.pairwise", (long)n3 * ((long)n3 - 1L)));
            LOG.statistics(new LongStatistic(this.STAT + n + "-items.joined", l));
            LOG.statistics(new LongStatistic(this.STAT + n + "-items.candidates", arrayList.size()));
        }
        return arrayList;
    }

    protected List<? extends Itemset> frequentItemsets(List<? extends Itemset> list, Relation<BitVector> relation, int n, DBIDs dBIDs, ArrayModifiableDBIDs arrayModifiableDBIDs, int n2) {
        if (list.size() < 1) {
            return Collections.emptyList();
        }
        Itemset itemset = list.get(0);
        if (list.size() > n2 * n2 * n2 * 100 && itemset instanceof SparseItemset) {
            List<? extends Itemset> list2 = list;
            return this.frequentItemsetsSparse(list2, relation, n, dBIDs, arrayModifiableDBIDs, n2);
        }
        Object object = dBIDs.iter();
        while (object.valid()) {
            BitVector bitVector = relation.get((DBIDRef)object);
            int n3 = 0;
            for (Itemset itemset2 : list) {
                if (!itemset2.containedIn(bitVector)) continue;
                itemset2.increaseSupport();
                ++n3;
            }
            if (n3 > n2) {
                arrayModifiableDBIDs.add((DBIDRef)object);
            }
            object.advance();
        }
        object = new ArrayList(list.size());
        for (Itemset itemset3 : list) {
            if (itemset3.getSupport() < n) continue;
            object.add(itemset3);
        }
        return object;
    }

    protected List<SparseItemset> frequentItemsetsSparse(List<SparseItemset> list, Relation<BitVector> relation, int n, DBIDs dBIDs, ArrayModifiableDBIDs arrayModifiableDBIDs, int n2) {
        int n3 = 0;
        int n4 = list.size();
        int[] nArray = new int[n2];
        int[] nArray2 = new int[n2];
        SparseItemset sparseItemset = new SparseItemset(nArray);
        Object object = dBIDs.iter();
        while (object.valid()) {
            BitVector bitVector = relation.get((DBIDRef)object);
            if (this.initializeSearchItemset(bitVector, nArray, nArray2)) {
                int n5 = 0;
                while (n3 < n4) {
                    if ((n3 = this.binarySearch(list, sparseItemset, n3, n4)) > 0) {
                        list.get(n3).increaseSupport();
                        ++n5;
                    } else {
                        n3 = -n3 - 1;
                    }
                    if (n3 < n4 && this.nextSearchItemset(bitVector, nArray, nArray2)) continue;
                }
                for (Itemset itemset : list) {
                    if (!itemset.containedIn(bitVector)) continue;
                    itemset.increaseSupport();
                    ++n5;
                }
                if (n5 > n2) {
                    arrayModifiableDBIDs.add((DBIDRef)object);
                }
            }
            object.advance();
        }
        object = new ArrayList(list.size());
        for (SparseItemset sparseItemset2 : list) {
            if (sparseItemset2.getSupport() < n) continue;
            object.add(sparseItemset2);
        }
        return object;
    }

    private boolean initializeSearchItemset(BitVector bitVector, int[] nArray, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray2[i] = i == 0 ? bitVector.iter() : bitVector.iterAdvance(nArray2[i - 1]);
            if (nArray2[i] < 0) {
                return false;
            }
            nArray[i] = bitVector.iterDim(nArray2[i]);
        }
        return true;
    }

    private boolean nextSearchItemset(BitVector bitVector, int[] nArray, int[] nArray2) {
        int n;
        for (int i = n = nArray.length - 1; i >= 0; --i) {
            int n2 = bitVector.iterAdvance(nArray2[i]);
            if (n2 < 0 || i != n && n2 == nArray2[i + 1]) continue;
            nArray2[i] = n2;
            nArray[i] = bitVector.iterDim(n2);
            return true;
        }
        return false;
    }

    private int binarySearch(List<SparseItemset> list, SparseItemset sparseItemset, int n, int n2) {
        --n2;
        while (n < n2) {
            int n3 = n + n2 >>> 1;
            SparseItemset sparseItemset2 = list.get(n3);
            int n4 = sparseItemset2.compareTo(sparseItemset);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    private StringBuilder debugDumpCandidates(StringBuilder stringBuilder, List<? extends Itemset> list, VectorFieldTypeInformation<BitVector> vectorFieldTypeInformation) {
        stringBuilder.append(':');
        for (Itemset itemset : list) {
            stringBuilder.append(" [");
            itemset.appendTo(stringBuilder, vectorFieldTypeInformation);
            stringBuilder.append(']');
        }
        return stringBuilder;
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.BIT_VECTOR_FIELD);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractFrequentItemsetAlgorithm.Parameterizer {
        @Override
        protected APRIORI makeInstance() {
            return new APRIORI(this.minsupp, this.minlength, this.maxlength);
        }
    }
}

