/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.logging.progress;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.progress.AbstractProgress;

public class FiniteProgress
extends AbstractProgress {
    private final int total;
    private final int totalLength;

    protected FiniteProgress(String string, int n) {
        super(string);
        this.total = n;
        this.totalLength = Integer.toString(n).length();
    }

    public FiniteProgress(String string, int n, Logging logging) {
        super(string);
        this.total = n;
        this.totalLength = Integer.toString(n).length();
        logging.progress(this);
    }

    @Override
    protected void setProcessed(int n) throws IllegalArgumentException {
        if (n > this.total) {
            throw new IllegalArgumentException(n + " exceeds total: " + this.total);
        }
        if (n < 0) {
            throw new IllegalArgumentException("Negative number of processed: " + n);
        }
        super.setProcessed(n);
    }

    @Override
    public StringBuilder appendToBuffer(StringBuilder stringBuilder) {
        String string = Integer.toString(this.getProcessed());
        int n = (int)((double)this.getProcessed() * 100.0 / (double)this.total);
        stringBuilder.append(this.getTask());
        stringBuilder.append(": ");
        for (int i = 0; i < this.totalLength - string.length(); ++i) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(this.getProcessed());
        stringBuilder.append(" [");
        if (n < 100) {
            stringBuilder.append(' ');
        }
        if (n < 10) {
            stringBuilder.append(' ');
        }
        stringBuilder.append(n);
        stringBuilder.append("%]");
        return stringBuilder;
    }

    @Override
    public boolean isComplete() {
        return this.getProcessed() == this.total;
    }

    public int getTotal() {
        return this.total;
    }

    public void ensureCompleted(Logging logging) {
        if (!this.isComplete()) {
            logging.warning("Progress had not completed automatically as expected: " + this.getProcessed() + "/" + this.total, new Throwable());
            this.setProcessed(this.getTotal());
            logging.progress(this);
        }
    }
}

