/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints;

import de.lmu.ifi.dbs.elki.utilities.optionhandling.ParameterException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.WrongParameterValueException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.constraints.GlobalParameterConstraint;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.IntParameter;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.ListParameter;

public class GlobalListSizeConstraint
implements GlobalParameterConstraint {
    private ListParameter<?, ?> list;
    private IntParameter length;

    public GlobalListSizeConstraint(ListParameter<?, ?> listParameter, IntParameter intParameter) {
        this.list = listParameter;
        this.length = intParameter;
    }

    @Override
    public void test() throws ParameterException {
        if (!this.list.isDefined() || !this.length.isDefined()) {
            return;
        }
        if (this.list.size() != this.length.intValue()) {
            throw new WrongParameterValueException("Global Parameter Constraint Error.\nThe size of the list parameter \"" + this.list.getName() + "\" must be " + this.length.getValue() + ", current size is " + this.list.size() + ". The value is defined by the integer parameter " + this.length.getName() + ".\n");
        }
    }

    @Override
    public String getDescription() {
        return "size(" + this.list.getName() + ") == " + this.length.getValue();
    }
}

