/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.selection;

import de.lmu.ifi.dbs.elki.data.NumberVector;
import de.lmu.ifi.dbs.elki.data.spatial.Polygon;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreListener;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDs;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.math.geometry.GrahamScanConvexHull2D;
import de.lmu.ifi.dbs.elki.math.linearalgebra.Vector;
import de.lmu.ifi.dbs.elki.result.DBIDSelection;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.exceptions.ObjectNotFoundException;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.projector.ScatterPlotProjector;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPath;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.scatterplot.AbstractScatterplotVisualization;
import org.w3c.dom.Element;

public class SelectionConvexHullVisualization
extends AbstractVisFactory {
    private static final String NAME = "Selection Hull";

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2, projection);
    }

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<ScatterPlotProjector> iter = VisualizationTree.filter(visualizerContext, object, ScatterPlotProjector.class);
        while (iter.valid()) {
            ScatterPlotProjector scatterPlotProjector = iter.get();
            Relation relation = scatterPlotProjector.getRelation();
            if (TypeUtil.NUMBER_VECTOR_FIELD.isAssignableFromType(relation.getDataTypeInformation())) {
                VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, visualizerContext.getSelectionResult(), relation, this);
                visualizationTask.level = 98;
                visualizationTask.addUpdateFlags(3);
                visualizerContext.addVis(visualizerContext.getSelectionResult(), visualizationTask);
                visualizerContext.addVis(scatterPlotProjector, visualizationTask);
            }
            iter.advance();
        }
    }

    public class Instance
    extends AbstractScatterplotVisualization
    implements DataStoreListener {
        public static final String SELECTEDHULL = "selectionConvexHull";

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
            super(visualizationTask, visualizationPlot, d, d2, projection);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            this.setupCanvas();
            this.addCSSClasses(this.svgp);
            DBIDSelection dBIDSelection = this.context.getSelection();
            if (dBIDSelection != null) {
                Object object;
                DBIDs dBIDs = dBIDSelection.getSelectedIds();
                GrahamScanConvexHull2D grahamScanConvexHull2D = new GrahamScanConvexHull2D();
                Object object2 = dBIDs.iter();
                while (object2.valid()) {
                    try {
                        object = this.proj.fastProjectDataToRenderSpace((NumberVector)this.rel.get((DBIDRef)object2));
                        if (object[0] == object[0] && object[1] == object[1]) {
                            grahamScanConvexHull2D.add(new Vector((double[])object));
                        }
                    }
                    catch (ObjectNotFoundException objectNotFoundException) {
                        // empty catch block
                    }
                    object2.advance();
                }
                object2 = grahamScanConvexHull2D.getHull();
                if (object2 != null && ((Polygon)object2).size() >= 3) {
                    object = new SVGPath((Polygon)object2);
                    Element element = ((SVGPath)object).makeElement(this.svgp);
                    SVGUtil.addCSSClass(element, SELECTEDHULL);
                    this.layer.appendChild(element);
                }
            }
        }

        private void addCSSClasses(SVGPlot sVGPlot) {
            if (!sVGPlot.getCSSClassManager().contains(SELECTEDHULL)) {
                StyleLibrary styleLibrary = this.context.getStyleLibrary();
                CSSClass cSSClass = new CSSClass(this, SELECTEDHULL);
                cSSClass.setStatement("stroke", styleLibrary.getColor("plot.selection"));
                cSSClass.setStatement("stroke-width", styleLibrary.getLineWidth("plot.selection"));
                cSSClass.setStatement("fill", styleLibrary.getColor("plot.selection"));
                cSSClass.setStatement("opacity", ".25");
                cSSClass.setStatement("stroke-linecap", "round");
                cSSClass.setStatement("stroke-linejoin", "round");
                sVGPlot.addCSSClassOrLogError(cSSClass);
            }
        }
    }
}

