/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.visualization.visualizers.visunproj;

import de.lmu.ifi.dbs.elki.data.Cluster;
import de.lmu.ifi.dbs.elki.data.Clustering;
import de.lmu.ifi.dbs.elki.data.model.Model;
import de.lmu.ifi.dbs.elki.utilities.datastructures.hierarchy.Hierarchy;
import de.lmu.ifi.dbs.elki.utilities.pairs.DoubleDoublePair;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTask;
import de.lmu.ifi.dbs.elki.visualization.VisualizationTree;
import de.lmu.ifi.dbs.elki.visualization.VisualizerContext;
import de.lmu.ifi.dbs.elki.visualization.css.CSSClass;
import de.lmu.ifi.dbs.elki.visualization.gui.VisualizationPlot;
import de.lmu.ifi.dbs.elki.visualization.projections.Projection;
import de.lmu.ifi.dbs.elki.visualization.style.ClusterStylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.StyleLibrary;
import de.lmu.ifi.dbs.elki.visualization.style.StylingPolicy;
import de.lmu.ifi.dbs.elki.visualization.style.marker.MarkerLibrary;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGPlot;
import de.lmu.ifi.dbs.elki.visualization.svg.SVGUtil;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisFactory;
import de.lmu.ifi.dbs.elki.visualization.visualizers.AbstractVisualization;
import de.lmu.ifi.dbs.elki.visualization.visualizers.Visualization;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KeyVisualization
extends AbstractVisFactory {
    private static final String NAME = "Cluster Key";

    @Override
    public void processNewResult(VisualizerContext visualizerContext, Object object) {
        Hierarchy.Iter<Clustering> iter = VisualizationTree.filterResults(visualizerContext, object, Clustering.class);
        if (!iter.valid()) {
            return;
        }
        Hierarchy.Iter<VisualizationTask> iter2 = VisualizationTree.filter(visualizerContext, VisualizationTask.class);
        while (iter2.valid()) {
            if (iter2.get().getFactory() instanceof KeyVisualization) {
                return;
            }
            iter2.advance();
        }
        VisualizationTask visualizationTask = new VisualizationTask(NAME, visualizerContext, visualizerContext.getStylingPolicy(), null, this);
        visualizationTask.level = 200;
        visualizationTask.addUpdateFlags(4);
        visualizationTask.reqwidth = 1.0;
        visualizationTask.reqheight = 1.0;
        visualizerContext.addVis(visualizerContext.getStylingPolicy(), visualizationTask);
    }

    protected static <M extends Model> int[] findDepth(Clustering<M> clustering) {
        Hierarchy<Cluster<M>> hierarchy = clustering.getClusterHierarchy();
        int[] nArray = new int[]{0, 0};
        Hierarchy.Iter<Cluster<M>> iter = clustering.iterToplevelClusters();
        while (iter.valid()) {
            KeyVisualization.findDepth(hierarchy, iter.get(), nArray);
            iter.advance();
        }
        return nArray;
    }

    private static <M extends Model> void findDepth(Hierarchy<Cluster<M>> hierarchy, Cluster<M> cluster, int[] nArray) {
        if (hierarchy.numChildren(cluster) > 0) {
            Hierarchy.Iter<Cluster<M>> iter = hierarchy.iterChildren(cluster);
            while (iter.valid()) {
                KeyVisualization.findDepth(hierarchy, iter.get(), nArray);
                iter.advance();
            }
            nArray[0] = nArray[0] + 1;
        } else {
            nArray[1] = nArray[1] + 1;
        }
    }

    protected static int getPreferredColumns(double d, double d2, int n, double d3) {
        double d4 = Math.ceil(Math.pow((double)n * d3, d2 / (d + d2)));
        return (int)Math.ceil((double)n / (d4 + 1.0));
    }

    @Override
    public Visualization makeVisualization(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2, Projection projection) {
        return new Instance(visualizationTask, visualizationPlot, d, d2);
    }

    @Override
    public boolean allowThumbnails(VisualizationTask visualizationTask) {
        return false;
    }

    public class Instance
    extends AbstractVisualization {
        private static final String KEY_CAPTION = "key-caption";
        private static final String KEY_ENTRY = "key-entry";
        private static final String KEY_HIERLINE = "key-hierarchy";

        public Instance(VisualizationTask visualizationTask, VisualizationPlot visualizationPlot, double d, double d2) {
            super(visualizationTask, visualizationPlot, d, d2);
            this.addListeners();
        }

        @Override
        public void fullRedraw() {
            double d;
            double d2;
            StylingPolicy stylingPolicy = this.context.getStylingPolicy();
            if (!(stylingPolicy instanceof ClusterStylingPolicy)) {
                Element element = this.svgp.svgText(0.1, 0.7, "No clustering selected.");
                SVGUtil.setCSSClass(element, KEY_CAPTION);
                this.layer.appendChild(element);
                return;
            }
            Clustering<?> clustering = ((ClusterStylingPolicy)stylingPolicy).getClustering();
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            MarkerLibrary markerLibrary = styleLibrary.markers();
            List<Cluster<?>> list = clustering.getAllClusters();
            List<Cluster<?>> list2 = clustering.getToplevelClusters();
            this.setupCSS(this.svgp);
            this.layer = this.svgp.svgElement("g");
            Element element = this.svgp.svgText(0.1, 0.7, clustering.getLongName());
            SVGUtil.setCSSClass(element, KEY_CAPTION);
            this.layer.appendChild(element);
            if (list.size() == list2.size()) {
                int n = list.size();
                int n2 = KeyVisualization.getPreferredColumns(this.getWidth(), this.getHeight(), n, 10.0);
                int hierarchy = (int)Math.ceil((double)n / (double)n2);
                int n3 = 0;
                for (Cluster<?> cluster : list) {
                    int n4 = n3 / hierarchy;
                    int n5 = n3 % hierarchy;
                    markerLibrary.useMarker(this.svgp, this.layer, 0.3 + 10.0 * (double)n4, (double)n5 + 1.5, n3, 0.3);
                    Element element2 = this.svgp.svgText(0.7 + 10.0 * (double)n4, (double)n5 + 1.7, cluster.getNameAutomatic());
                    SVGUtil.setCSSClass(element2, KEY_ENTRY);
                    this.layer.appendChild(element2);
                    ++n3;
                }
                d2 = (double)n2 * 10.0;
                d = hierarchy;
            } else {
                TObjectIntHashMap<Cluster<Model>> d3 = new TObjectIntHashMap<Cluster<Model>>(list.size());
                int n = 0;
                for (Cluster<?> object2 : list) {
                    d3.put(object2, n);
                    ++n;
                }
                DoubleDoublePair doubleDoublePair = new DoubleDoublePair(0.0, 1.0);
                DoubleDoublePair doubleDoublePair2 = new DoubleDoublePair(0.0, 1.0);
                Hierarchy<Cluster<Model>> hierarchy = clustering.getClusterHierarchy();
                for (Cluster<Model> cluster : list2) {
                    this.drawHierarchy(this.svgp, markerLibrary, doubleDoublePair, doubleDoublePair2, 0, cluster, d3, hierarchy);
                }
                d2 = doubleDoublePair.first;
                d = doubleDoublePair.second;
            }
            double d3 = styleLibrary.getSize("margin");
            String string = SVGUtil.makeMarginTransform(this.getWidth(), this.getHeight(), d2, d, d3 / 100.0);
            SVGUtil.setAtt(this.layer, "transform", string);
        }

        private double drawHierarchy(SVGPlot sVGPlot, MarkerLibrary markerLibrary, DoubleDoublePair doubleDoublePair, DoubleDoublePair doubleDoublePair2, int n, Cluster<Model> cluster, TObjectIntMap<Cluster<Model>> tObjectIntMap, Hierarchy<Cluster<Model>> hierarchy) {
            double d;
            Object object;
            DoubleDoublePair doubleDoublePair3 = new DoubleDoublePair(doubleDoublePair2.first + 8.0, doubleDoublePair2.second);
            int n2 = hierarchy.numChildren(cluster);
            if (n2 > 0) {
                object = new double[n2];
                Hierarchy.Iter<Cluster<Model>> iter = hierarchy.iterChildren(cluster);
                int n3 = 0;
                while (iter.valid()) {
                    object[n3] = this.drawHierarchy(sVGPlot, markerLibrary, doubleDoublePair, doubleDoublePair3, n, iter.get(), tObjectIntMap, hierarchy);
                    iter.advance();
                    ++n3;
                }
                d = (doubleDoublePair2.second + doubleDoublePair3.second) * 0.5;
                for (n3 = 0; n3 < n2; ++n3) {
                    Element element = sVGPlot.svgLine(doubleDoublePair2.first + 8.0 - 1.0, d + 0.5, doubleDoublePair2.first + 8.0, object[n3] + 0.5);
                    SVGUtil.setCSSClass(element, KEY_HIERLINE);
                    this.layer.appendChild(element);
                }
                doubleDoublePair2.second = doubleDoublePair3.second;
            } else {
                d = doubleDoublePair2.second + 0.5;
                doubleDoublePair2.second += 1.0;
            }
            markerLibrary.useMarker(sVGPlot, this.layer, 0.3 + doubleDoublePair2.first, d + 0.5, tObjectIntMap.get(cluster), 0.3);
            object = sVGPlot.svgText(0.7 + doubleDoublePair2.first, d + 0.7, cluster.getNameAutomatic());
            SVGUtil.setCSSClass((Element)object, KEY_ENTRY);
            this.layer.appendChild((Node)object);
            doubleDoublePair.first = Math.max(doubleDoublePair.first, doubleDoublePair2.first + 8.0);
            doubleDoublePair.second = Math.max(doubleDoublePair.second, doubleDoublePair2.second);
            return d;
        }

        protected void setupCSS(SVGPlot sVGPlot) {
            StyleLibrary styleLibrary = this.context.getStyleLibrary();
            double d = styleLibrary.getTextSize("key");
            String string = styleLibrary.getFontFamily("key");
            String string2 = styleLibrary.getColor("key");
            CSSClass cSSClass = new CSSClass(sVGPlot, KEY_CAPTION);
            cSSClass.setStatement("font-size", d);
            cSSClass.setStatement("font-family", string);
            cSSClass.setStatement("fill", string2);
            cSSClass.setStatement("font-weight", "bold");
            sVGPlot.addCSSClassOrLogError(cSSClass);
            CSSClass cSSClass2 = new CSSClass(sVGPlot, KEY_ENTRY);
            cSSClass2.setStatement("font-size", d);
            cSSClass2.setStatement("font-family", string);
            cSSClass2.setStatement("fill", string2);
            sVGPlot.addCSSClassOrLogError(cSSClass2);
            CSSClass cSSClass3 = new CSSClass(sVGPlot, KEY_HIERLINE);
            cSSClass3.setStatement("stroke", string2);
            cSSClass3.setStatement("stroke-width", styleLibrary.getLineWidth("key.hierarchy") / 100.0);
            sVGPlot.addCSSClassOrLogError(cSSClass3);
            sVGPlot.updateStyleElement();
        }
    }
}

