/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.models;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelNotFoundException;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.IModelElement;
import org.eclipse.epsilon.eol.models.ModelGroup;
import org.eclipse.epsilon.eol.models.transactions.ModelRepositoryTransactionSupport;

public class ModelRepository {
    ModelRepositoryTransactionSupport transactionSupport;
    List<IModel> models = new ArrayList<IModel>();
    private HashMap<String, ModelGroup> cachedModelGroups = new HashMap();

    public ModelRepositoryTransactionSupport getTransactionSupport() {
        if (this.transactionSupport == null) {
            this.transactionSupport = new ModelRepositoryTransactionSupport(this);
        }
        return this.transactionSupport;
    }

    public void addModel(IModel model) {
        if (!this.models.contains(model)) {
            this.models.add(model);
        }
    }

    public void removeModel(IModel model) {
        this.models.remove(model);
        this.cachedModelGroups = new HashMap();
    }

    public IModel getModelByNameSafe(String modelName) {
        try {
            return this.getModelByName(modelName);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public IModel getModelByName(String modelName) throws EolModelNotFoundException {
        if (modelName.length() == 0) {
            if (this.models.size() > 0) {
                return this.models.get(0);
            }
            return null;
        }
        for (IModel model : this.models) {
            if (!model.getName().equals(modelName)) continue;
            return model;
        }
        ModelGroup modelGroup = this.cachedModelGroups.get(modelName);
        if (modelGroup == null) {
            modelGroup = new ModelGroup(this, modelName);
            this.cachedModelGroups.put(modelName, modelGroup);
        }
        return modelGroup;
    }

    public AmbiguityCheckResult checkAmbiguity(String typeName) {
        List<String> namesOfModelsThatHaveThisType = this.namesOfModelsThatHaveTheType(typeName);
        boolean typeIsAmbiguous = namesOfModelsThatHaveThisType.size() > 1;
        String nameOfSelectedModel = namesOfModelsThatHaveThisType.isEmpty() ? "" : namesOfModelsThatHaveThisType.get(0);
        return new AmbiguityCheckResult(typeIsAmbiguous, namesOfModelsThatHaveThisType, nameOfSelectedModel);
    }

    private List<String> namesOfModelsThatHaveTheType(String typeName) {
        LinkedList<String> modelNames = new LinkedList<String>();
        for (IModel model : this.getModels()) {
            if (!model.hasType(typeName)) continue;
            modelNames.add(model.getName());
        }
        return modelNames;
    }

    public Object getEnumerationValue(String modelAndEnumerationAndLabel) throws EolModelNotFoundException, EolEnumerationValueNotFoundException {
        String modelName = this.getModelName(modelAndEnumerationAndLabel);
        String enumerationAndLabel = this.getMetaClassName(modelAndEnumerationAndLabel);
        String enumeration = this.getEnumeration(enumerationAndLabel);
        String label = this.getLabel(enumerationAndLabel);
        IModel model = this.getModelByName(modelName);
        return model.getEnumerationValue(enumeration, label);
    }

    public IModel getOwningModel(Object instance) {
        if (instance instanceof IModelElement) {
            return ((IModelElement)instance).getOwningModel();
        }
        for (IModel model : this.models) {
            if (!model.owns(instance)) continue;
            return model;
        }
        return null;
    }

    protected String getMetaClassName(String modelAndMetaClass) {
        if (modelAndMetaClass.indexOf("!") != -1) {
            return modelAndMetaClass.split("!")[1];
        }
        return modelAndMetaClass;
    }

    protected String getModelName(String modelAndMetaClass) {
        if (modelAndMetaClass.indexOf("!") != -1) {
            return modelAndMetaClass.split("!")[0];
        }
        return "";
    }

    protected String getEnumeration(String enumerationAndLabel) {
        return enumerationAndLabel.split("#")[0];
    }

    protected String getLabel(String enumerationAndLabel) {
        return enumerationAndLabel.split("#")[1];
    }

    public void dispose() {
        for (IModel model : this.models) {
            model.dispose();
            Object var1_2 = null;
        }
        this.models.clear();
        this.transactionSupport = null;
    }

    public List<IModel> getModels() {
        return this.models;
    }

    public String toString() {
        return "ModelRepository [transactionSupport=" + this.transactionSupport + ", models=" + this.models + "]";
    }

    public static class AmbiguityCheckResult {
        public final boolean isAmbiguous;
        public final Collection<String> namesOfOwningModels;
        public final String nameOfSelectedModel;

        public AmbiguityCheckResult(boolean isAmbiguous, Collection<String> namesOfOwningModels, String nameOfSelectedModel) {
            this.isAmbiguous = isAmbiguous;
            this.namesOfOwningModels = namesOfOwningModels;
            this.nameOfSelectedModel = nameOfSelectedModel;
        }
    }
}

