/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.workflow.tasks;

import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.eclipse.epsilon.ecl.trace.MatchTrace;
import org.eclipse.epsilon.emc.composite.CompositeModel;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.workflow.tasks.EpsilonTask;
import org.eclipse.epsilon.workflow.tasks.nestedelements.ModelNestedElement;

public class LoadCompositeModelTask
extends EpsilonTask {
    protected List<ModelNestedElement> modelNestedElements = new ArrayList<ModelNestedElement>();
    protected String matchTrace = null;
    protected String name = null;

    @Override
    public void executeImpl() throws BuildException {
        ArrayList<IModel> models = new ArrayList<IModel>();
        for (ModelNestedElement modelNestedElement : this.modelNestedElements) {
            try {
                models.add(this.getProjectRepository().getModelByName(modelNestedElement.getRef()));
            }
            catch (Exception ex) {
                throw new BuildException((Throwable)ex);
            }
        }
        MatchTrace matchTrace = null;
        try {
            matchTrace = (MatchTrace)this.getProjectStackFrame().get(this.matchTrace).getValue();
        }
        catch (Exception ex) {
            throw new BuildException("A variable named " + this.matchTrace + " of type MatchTrace has not been found in the context.");
        }
        CompositeModel composite = new CompositeModel(models, matchTrace);
        composite.setName(this.name);
        this.getProjectRepository().addModel(composite);
    }

    public ModelNestedElement createModel() {
        ModelNestedElement model = new ModelNestedElement();
        this.modelNestedElements.add(model);
        return model;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMatchTrace(String matchTrace) {
        this.matchTrace = matchTrace;
    }
}

