/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.algorithm.outlier.trivial;

import de.lmu.ifi.dbs.elki.algorithm.AbstractAlgorithm;
import de.lmu.ifi.dbs.elki.algorithm.outlier.OutlierAlgorithm;
import de.lmu.ifi.dbs.elki.data.type.NoSupportedDataTypeException;
import de.lmu.ifi.dbs.elki.data.type.TypeInformation;
import de.lmu.ifi.dbs.elki.data.type.TypeUtil;
import de.lmu.ifi.dbs.elki.database.Database;
import de.lmu.ifi.dbs.elki.database.datastore.DataStoreUtil;
import de.lmu.ifi.dbs.elki.database.datastore.WritableDoubleDataStore;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.relation.DoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.MaterializedDoubleRelation;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierResult;
import de.lmu.ifi.dbs.elki.result.outlier.OutlierScoreMeta;
import de.lmu.ifi.dbs.elki.result.outlier.ProbabilisticOutlierScore;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.PatternParameter;
import java.util.regex.Pattern;

public class ByLabelOutlier
extends AbstractAlgorithm<OutlierResult>
implements OutlierAlgorithm {
    private static final Logging LOG = Logging.getLogger(ByLabelOutlier.class);
    public static final String DEFAULT_PATTERN = ".*(Outlier|Noise).*";
    final Pattern pattern;

    public ByLabelOutlier(Pattern pattern) {
        this.pattern = pattern;
    }

    public ByLabelOutlier() {
        this(Pattern.compile(DEFAULT_PATTERN));
    }

    @Override
    public TypeInformation[] getInputTypeRestriction() {
        return TypeUtil.array(TypeUtil.GUESSED_LABEL);
    }

    @Override
    public OutlierResult run(Database database) {
        try {
            Relation relation = database.getRelation(TypeUtil.CLASSLABEL, new Object[0]);
            return this.run(relation);
        }
        catch (NoSupportedDataTypeException noSupportedDataTypeException) {
            return this.run(database.getRelation(this.getInputTypeRestriction()[0], new Object[0]));
        }
    }

    public OutlierResult run(Relation<?> relation) {
        Object object;
        WritableDoubleDataStore writableDoubleDataStore = DataStoreUtil.makeDoubleStorage(relation.getDBIDs(), 2);
        Object object2 = relation.iterDBIDs();
        while (object2.valid()) {
            object = relation.get((DBIDRef)object2).toString();
            double d = this.pattern.matcher((CharSequence)object).matches() ? 1.0 : 0.0;
            writableDoubleDataStore.putDouble((DBIDRef)object2, d);
            object2.advance();
        }
        object2 = new MaterializedDoubleRelation("By label outlier scores", "label-outlier", writableDoubleDataStore, relation.getDBIDs());
        object = new ProbabilisticOutlierScore();
        return new OutlierResult((OutlierScoreMeta)object, (DoubleRelation)object2);
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        public static final OptionID OUTLIER_PATTERN_ID = new OptionID("outlier.pattern", "Label pattern to match outliers.");
        private Pattern pattern;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            super.makeOptions(parameterization);
            PatternParameter patternParameter = new PatternParameter(OUTLIER_PATTERN_ID, ByLabelOutlier.DEFAULT_PATTERN);
            if (parameterization.grab(patternParameter)) {
                this.pattern = (Pattern)patternParameter.getValue();
            }
        }

        @Override
        protected ByLabelOutlier makeInstance() {
            return new ByLabelOutlier(this.pattern);
        }
    }
}

