/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mktab;

import de.lmu.ifi.dbs.elki.database.ids.DBID;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.AbstractMkTreeUnified;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.MkTreeSettings;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabDirectoryEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabEntry;
import de.lmu.ifi.dbs.elki.index.tree.metrical.mtreevariants.mktrees.mktab.MkTabTreeNode;
import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.persistent.PageFile;
import java.util.Map;

public abstract class MkTabTree<O>
extends AbstractMkTreeUnified<O, MkTabTreeNode<O>, MkTabEntry, MkTreeSettings<O, MkTabTreeNode<O>, MkTabEntry>> {
    private static final Logging LOG = Logging.getLogger(MkTabTree.class);

    public MkTabTree(Relation<O> relation, PageFile<MkTabTreeNode<O>> pageFile, MkTreeSettings<O, MkTabTreeNode<O>, MkTabEntry> mkTreeSettings) {
        super(relation, pageFile, mkTreeSettings);
    }

    @Override
    protected void preInsert(MkTabEntry mkTabEntry) {
        throw new UnsupportedOperationException("Insertion of single objects is not supported!");
    }

    @Override
    public void insert(MkTabEntry mkTabEntry, boolean bl) {
        throw new UnsupportedOperationException("Insertion of single objects is not supported!");
    }

    @Override
    public DoubleDBIDList reverseKNNQuery(DBIDRef dBIDRef, int n) {
        if (n > this.getKmax()) {
            throw new IllegalArgumentException("Parameter k has to be less or equal than parameter kmax of the MkTab-Tree!");
        }
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList();
        this.doReverseKNNQuery(n, dBIDRef, null, (MkTabTreeNode)this.getRoot(), modifiableDoubleDBIDList);
        modifiableDoubleDBIDList.sort();
        return modifiableDoubleDBIDList;
    }

    @Override
    protected void initializeCapacities(MkTabEntry mkTabEntry) {
        int n = 8;
        double d = 12.125;
        if ((double)this.getPageSize() - d < 0.0) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        this.dirCapacity = (int)((double)this.getPageSize() - d) / (8 + n + n + 4 + this.getKmax() * n) + 1;
        if (this.dirCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.dirCapacity < 10) {
            LOG.warning("Page size is choosen too small! Maximum number of entries in a directory node = " + (this.dirCapacity - 1));
        }
        this.leafCapacity = (int)((double)this.getPageSize() - d) / (4 + n + 4 + this.getKmax() * n) + 1;
        if (this.leafCapacity <= 1) {
            throw new RuntimeException("Node size of " + this.getPageSize() + " Bytes is chosen too small!");
        }
        if (this.leafCapacity < 10) {
            LOG.warning("Page size is choosen too small! Maximum number of entries in a leaf node = " + (this.leafCapacity - 1));
        }
    }

    @Override
    protected void kNNdistanceAdjustment(MkTabEntry mkTabEntry, Map<DBID, KNNList> map) {
        MkTabTreeNode mkTabTreeNode = (MkTabTreeNode)this.getNode(mkTabEntry);
        double[] dArray = this.initKnnDistanceList();
        if (mkTabTreeNode.isLeaf()) {
            for (int i = 0; i < mkTabTreeNode.getNumEntries(); ++i) {
                MkTabEntry mkTabEntry2 = (MkTabEntry)mkTabTreeNode.getEntry(i);
                KNNList kNNList = map.get(this.getPageID(mkTabEntry2));
                double[] dArray2 = new double[kNNList.size()];
                int n = 0;
                DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
                while (doubleDBIDListIter.valid()) {
                    dArray2[n] = doubleDBIDListIter.doubleValue();
                    doubleDBIDListIter.advance();
                    ++n;
                }
                mkTabEntry2.setKnnDistances(dArray2);
                dArray = this.max(dArray, mkTabEntry2.getKnnDistances());
            }
        } else {
            for (int i = 0; i < mkTabTreeNode.getNumEntries(); ++i) {
                MkTabEntry mkTabEntry3 = (MkTabEntry)mkTabTreeNode.getEntry(i);
                this.kNNdistanceAdjustment(mkTabEntry3, map);
                dArray = this.max(dArray, mkTabEntry3.getKnnDistances());
            }
        }
        mkTabEntry.setKnnDistances(dArray);
    }

    @Override
    protected MkTabTreeNode<O> createNewLeafNode() {
        return new MkTabTreeNode(this.leafCapacity, true);
    }

    @Override
    protected MkTabTreeNode<O> createNewDirectoryNode() {
        return new MkTabTreeNode(this.dirCapacity, false);
    }

    @Override
    protected MkTabEntry createNewDirectoryEntry(MkTabTreeNode<O> mkTabTreeNode, DBID dBID, double d) {
        return new MkTabDirectoryEntry(dBID, d, mkTabTreeNode.getPageID(), mkTabTreeNode.coveringRadiusFromEntries(dBID, this), mkTabTreeNode.kNNDistances());
    }

    @Override
    protected MkTabEntry createRootEntry() {
        return new MkTabDirectoryEntry(null, 0.0, 0, 0.0, this.initKnnDistanceList());
    }

    private void doReverseKNNQuery(int n, DBIDRef dBIDRef, MkTabEntry mkTabEntry, MkTabTreeNode<O> mkTabTreeNode, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
        if (mkTabTreeNode.isLeaf()) {
            for (int i = 0; i < mkTabTreeNode.getNumEntries(); ++i) {
                MkTabEntry mkTabEntry2 = (MkTabEntry)mkTabTreeNode.getEntry(i);
                double d = this.distance(mkTabEntry2.getRoutingObjectID(), dBIDRef);
                if (!(d <= mkTabEntry2.getKnnDistance(n))) continue;
                modifiableDoubleDBIDList.add(d, mkTabEntry2.getRoutingObjectID());
            }
        } else {
            for (int i = 0; i < mkTabTreeNode.getNumEntries(); ++i) {
                double d;
                MkTabEntry mkTabEntry3 = (MkTabEntry)mkTabTreeNode.getEntry(i);
                double d2 = mkTabEntry != null ? mkTabEntry.getKnnDistance(n) : Double.POSITIVE_INFINITY;
                double d3 = this.distance(mkTabEntry3.getRoutingObjectID(), dBIDRef);
                double d4 = d = mkTabEntry3.getCoveringRadius() > d3 ? 0.0 : d3 - mkTabEntry3.getCoveringRadius();
                if (!(d <= d2)) continue;
                MkTabTreeNode mkTabTreeNode2 = (MkTabTreeNode)this.getNode(mkTabEntry3);
                this.doReverseKNNQuery(n, dBIDRef, mkTabEntry3, mkTabTreeNode2, modifiableDoubleDBIDList);
            }
        }
    }

    private double[] max(double[] dArray, double[] dArray2) {
        if (dArray.length != dArray2.length) {
            throw new RuntimeException("different lengths!");
        }
        double[] dArray3 = new double[dArray.length];
        for (int i = 0; i < dArray.length; ++i) {
            dArray3[i] = Math.max(dArray[i], dArray2[i]);
        }
        return dArray3;
    }

    private double[] initKnnDistanceList() {
        double[] dArray = new double[this.getKmax()];
        return dArray;
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

