/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.spacefillingcurves;

import de.lmu.ifi.dbs.elki.data.spatial.SpatialComparable;
import de.lmu.ifi.dbs.elki.data.spatial.SpatialSingleMeanComparator;
import de.lmu.ifi.dbs.elki.math.spacefillingcurves.AbstractSpatialSorter;
import de.lmu.ifi.dbs.elki.utilities.datastructures.QuickSelect;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import java.util.List;

@Reference(authors="J. L. Bentley", title="Multidimensional binary search trees used for associative searching", booktitle="Communications of the ACM, Vol. 18 Issue 9, Sept. 1975", url="http://dx.doi.org/10.1145/361002.361007")
public class BinarySplitSpatialSorter
extends AbstractSpatialSorter {
    @Override
    public <T extends SpatialComparable> void sort(List<T> list, int n, int n2, double[] dArray, int[] nArray) {
        int n3 = nArray != null ? nArray.length : dArray.length >>> 1;
        this.binarySplitSort(list, n, n2, 0, n3, nArray, new SpatialSingleMeanComparator(0));
    }

    private <T extends SpatialComparable> void binarySplitSort(List<T> list, int n, int n2, int n3, int n4, int[] nArray, SpatialSingleMeanComparator spatialSingleMeanComparator) {
        int n5 = n + (n2 - n >>> 1);
        spatialSingleMeanComparator.setDimension(nArray != null ? nArray[n3] : n3);
        QuickSelect.quickSelect(list, spatialSingleMeanComparator, n, n2, n5);
        int n6 = (n3 + 1) % n4;
        if (n < n5 - 1) {
            this.binarySplitSort(list, n, n5, n6, n4, nArray, spatialSingleMeanComparator);
        }
        if (n5 + 2 < n2) {
            this.binarySplitSort(list, n5 + 1, n2, n6, n4, nArray, spatialSingleMeanComparator);
        }
    }
}

