/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution;

import de.lmu.ifi.dbs.elki.math.random.RandomFactory;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.AbstractDistribution;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.DoubleParameter;
import java.util.Random;

public class ExponentialDistribution
extends AbstractDistribution {
    double rate;
    double location;

    public ExponentialDistribution(double d) {
        this(d, 0.0, (Random)null);
    }

    public ExponentialDistribution(double d, double d2) {
        this(d, d2, (Random)null);
    }

    public ExponentialDistribution(double d, Random random) {
        this(d, 0.0, random);
    }

    public ExponentialDistribution(double d, double d2, Random random) {
        super(random);
        this.rate = d;
        this.location = d2;
    }

    public ExponentialDistribution(double d, double d2, RandomFactory randomFactory) {
        super(randomFactory);
        this.rate = d;
        this.location = d2;
    }

    @Override
    public double pdf(double d) {
        if (d < this.location) {
            return 0.0;
        }
        return this.rate * Math.exp(-this.rate * (d - this.location));
    }

    public static double pdf(double d, double d2) {
        if (d < 0.0) {
            return 0.0;
        }
        return d2 * Math.exp(-d2 * d);
    }

    @Override
    public double cdf(double d) {
        if (d < this.location) {
            return 0.0;
        }
        return 1.0 - Math.exp(-this.rate * (d - this.location));
    }

    public static double cdf(double d, double d2) {
        if (d < 0.0) {
            return 0.0;
        }
        return 1.0 - Math.exp(-d2 * d);
    }

    @Override
    public double quantile(double d) {
        return -Math.log(1.0 - d) / this.rate + this.location;
    }

    public static double quantile(double d, double d2) {
        return -Math.log(1.0 - d) / d2;
    }

    @Override
    public double nextRandom() {
        return -Math.log(this.random.nextDouble()) / this.rate + this.location;
    }

    @Override
    public String toString() {
        return "ExponentialDistribution(rate=" + this.rate + ", location=" + this.location + ")";
    }

    public static class Parameterizer
    extends AbstractDistribution.Parameterizer {
        public static final OptionID RATE_ID = new OptionID("distribution.exponential.rate", "Exponential distribution rate (lambda) parameter (inverse of scale).");
        double location;
        double rate;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            DoubleParameter doubleParameter;
            super.makeOptions(parameterization);
            DoubleParameter doubleParameter2 = new DoubleParameter(LOCATION_ID);
            if (parameterization.grab(doubleParameter2)) {
                this.location = doubleParameter2.doubleValue();
            }
            if (parameterization.grab(doubleParameter = new DoubleParameter(RATE_ID))) {
                this.rate = doubleParameter.doubleValue();
            }
        }

        @Override
        protected ExponentialDistribution makeInstance() {
            return new ExponentialDistribution(this.rate, this.location, this.rnd);
        }
    }
}

