/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.knn;

import de.lmu.ifi.dbs.elki.database.ids.ArrayDBIDs;
import de.lmu.ifi.dbs.elki.database.ids.DBIDArrayIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDListIter;
import de.lmu.ifi.dbs.elki.database.ids.KNNList;
import de.lmu.ifi.dbs.elki.database.query.knn.KNNQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.index.preprocessed.knn.AbstractMaterializeKNNPreprocessor;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import java.util.ArrayList;
import java.util.List;

public class PreprocessorKNNQuery<O>
implements KNNQuery<O> {
    protected final Relation<? extends O> relation;
    private final AbstractMaterializeKNNPreprocessor<O> preprocessor;
    private boolean warned = false;

    public PreprocessorKNNQuery(Relation<O> relation, AbstractMaterializeKNNPreprocessor<O> abstractMaterializeKNNPreprocessor) {
        this.relation = relation;
        this.preprocessor = abstractMaterializeKNNPreprocessor;
    }

    @Override
    public KNNList getKNNForDBID(DBIDRef dBIDRef, int n) {
        if (!this.warned && n > this.preprocessor.getK()) {
            LoggingUtil.warning("Requested more neighbors than preprocessed: requested " + n + " preprocessed " + this.preprocessor.getK(), new Throwable());
            this.warned = true;
        }
        if (n < this.preprocessor.getK()) {
            int n2;
            KNNList kNNList = this.preprocessor.get(dBIDRef);
            DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
            double d = doubleDBIDListIter.seek(n2 - 1).doubleValue();
            doubleDBIDListIter.advance();
            for (n2 = n; doubleDBIDListIter.valid() && d < doubleDBIDListIter.doubleValue() && n2 < n; ++n2) {
                doubleDBIDListIter.advance();
            }
            return n2 < kNNList.size() ? DBIDUtil.subList(kNNList, n2) : kNNList;
        }
        return this.preprocessor.get(dBIDRef);
    }

    @Override
    public List<KNNList> getKNNForBulkDBIDs(ArrayDBIDs arrayDBIDs, int n) {
        if (!this.warned && n > this.preprocessor.getK()) {
            LoggingUtil.warning("Requested more neighbors than preprocessed: requested " + n + " preprocessed " + this.preprocessor.getK(), new Throwable());
            this.warned = true;
        }
        if (n < this.preprocessor.getK()) {
            ArrayList<KNNList> arrayList = new ArrayList<KNNList>(arrayDBIDs.size());
            DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
            while (dBIDArrayIter.valid()) {
                int n2;
                KNNList kNNList = this.preprocessor.get(dBIDArrayIter);
                DoubleDBIDListIter doubleDBIDListIter = kNNList.iter();
                double d = doubleDBIDListIter.seek(n2 - 1).doubleValue();
                doubleDBIDListIter.advance();
                for (n2 = n; doubleDBIDListIter.valid() && d < doubleDBIDListIter.doubleValue() && n2 < n; ++n2) {
                    doubleDBIDListIter.advance();
                }
                arrayList.add(n2 < kNNList.size() ? DBIDUtil.subList(kNNList, n2) : kNNList);
                dBIDArrayIter.advance();
            }
            return arrayList;
        }
        ArrayList<KNNList> arrayList = new ArrayList<KNNList>(arrayDBIDs.size());
        DBIDArrayIter dBIDArrayIter = arrayDBIDs.iter();
        while (dBIDArrayIter.valid()) {
            arrayList.add(this.preprocessor.get(dBIDArrayIter));
            dBIDArrayIter.advance();
        }
        return arrayList;
    }

    @Override
    public KNNList getKNNForObject(O o, int n) {
        throw new AbortException("Preprocessor KNN query only supports ID queries.");
    }

    public AbstractMaterializeKNNPreprocessor<O> getPreprocessor() {
        return this.preprocessor;
    }
}

