/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.datasource;

import de.lmu.ifi.dbs.elki.datasource.InputStreamDatabaseConnection;
import de.lmu.ifi.dbs.elki.datasource.filter.ObjectFilter;
import de.lmu.ifi.dbs.elki.datasource.parser.ArffParser;
import de.lmu.ifi.dbs.elki.datasource.parser.NumberVectorLabelParser;
import de.lmu.ifi.dbs.elki.datasource.parser.Parser;
import de.lmu.ifi.dbs.elki.utilities.Alias;
import de.lmu.ifi.dbs.elki.utilities.FileUtil;
import de.lmu.ifi.dbs.elki.utilities.exceptions.AbortException;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.OptionID;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameterization.Parameterization;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.parameters.FileParameter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

@Alias(value={"de.lmu.ifi.dbs.elki.database.connection.FileBasedDatabaseConnection"})
public class FileBasedDatabaseConnection
extends InputStreamDatabaseConnection {
    public FileBasedDatabaseConnection(List<ObjectFilter> list, Parser parser, File file) {
        super(list, parser);
        try {
            this.in = new BufferedInputStream(FileUtil.tryGzipInput(new FileInputStream(file)));
        }
        catch (IOException iOException) {
            throw new AbortException("Could not load input file: " + file, iOException);
        }
    }

    public FileBasedDatabaseConnection(List<ObjectFilter> list, Parser parser, String string) {
        super(list, parser);
        try {
            this.in = new BufferedInputStream(FileUtil.tryGzipInput(new FileInputStream(string)));
        }
        catch (IOException iOException) {
            throw new AbortException("Could not load input file: " + string, iOException);
        }
    }

    public FileBasedDatabaseConnection(List<ObjectFilter> list, Parser parser, InputStream inputStream) {
        super(list, parser);
        this.in = inputStream;
    }

    public static class Parameterizer
    extends InputStreamDatabaseConnection.Parameterizer {
        public static final OptionID INPUT_ID = new OptionID("dbc.in", "The name of the input file to be parsed.");
        protected File infile;

        @Override
        protected void makeOptions(Parameterization parameterization) {
            Class clazz = NumberVectorLabelParser.class;
            FileParameter fileParameter = new FileParameter(INPUT_ID, FileParameter.FileType.INPUT_FILE);
            if (parameterization.grab(fileParameter)) {
                this.infile = (File)fileParameter.getValue();
                String string = this.infile.getName();
                if (string != null && (string.endsWith(".arff") || string.endsWith(".arff.gz"))) {
                    clazz = ArffParser.class;
                }
            }
            this.configParser(parameterization, Parser.class, clazz);
            this.configFilters(parameterization);
        }

        @Override
        protected FileBasedDatabaseConnection makeInstance() {
            return new FileBasedDatabaseConnection((List<ObjectFilter>)this.filters, this.parser, this.infile);
        }
    }
}

