/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator;

import de.lmu.ifi.dbs.elki.math.MathUtil;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GammaDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.GeneralizedExtremeValueDistribution;
import de.lmu.ifi.dbs.elki.math.statistics.distribution.estimator.AbstractLMMEstimator;
import de.lmu.ifi.dbs.elki.utilities.documentation.Reference;
import de.lmu.ifi.dbs.elki.utilities.optionhandling.AbstractParameterizer;

@Reference(authors="J.R.M. Hosking, J. R. Wallis, and E. F. Wood", title="Estimation of the generalized extreme-value distribution by the method of probability-weighted moments.", booktitle="Technometrics 27.3", url="http://dx.doi.org/10.1080/00401706.1985.10488049")
public class GeneralizedExtremeValueLMMEstimator
extends AbstractLMMEstimator<GeneralizedExtremeValueDistribution> {
    public static final GeneralizedExtremeValueLMMEstimator STATIC = new GeneralizedExtremeValueLMMEstimator();
    private static final double A0 = 0.2837753;
    private static final double A1 = -1.21096399;
    private static final double A2 = -2.50728214;
    private static final double A3 = -1.13455566;
    private static final double A4 = -0.07138022;
    private static final double B1 = 2.06189696;
    private static final double B2 = 1.31912239;
    private static final double B3 = 0.25077104;
    private static final double C1 = 1.59921491;
    private static final double C2 = -0.48832213;
    private static final double C3 = 0.01573152;
    private static final double D1 = -0.64363929;
    private static final double D2 = 0.08985247;
    static int MAXIT = 20;

    private GeneralizedExtremeValueLMMEstimator() {
    }

    @Override
    public int getNumMoments() {
        return 3;
    }

    @Override
    public GeneralizedExtremeValueDistribution estimateFromLMoments(double[] dArray) {
        double d;
        double d2;
        double d3 = dArray[2];
        if (Math.abs(d3) < 1.0E-50 || d3 >= 1.0) {
            throw new ArithmeticException("Invalid moment estimation.");
        }
        if (d3 > 0.0) {
            d2 = 1.0 - d3;
            d = (-1.0 + d2 * (1.59921491 + d2 * (-0.48832213 + d2 * 0.01573152))) / (1.0 + d2 * (-0.64363929 + d2 * 0.08985247));
            if (Math.abs(d) < 1.0E-50) {
                double d4 = 0.0;
                double d5 = dArray[1] * MathUtil.ONE_BY_LOG2;
                double d6 = dArray[0] - Math.E * d5;
                return new GeneralizedExtremeValueDistribution(d6, d5, d4);
            }
        } else {
            d = (0.2837753 + d3 * (-1.21096399 + d3 * (-2.50728214 + d3 * (-1.13455566 + d3 * -0.07138022)))) / (1.0 + d3 * (2.06189696 + d3 * (1.31912239 + d3 * 0.25077104)));
            if (d3 < -0.8) {
                if (d3 <= -0.97) {
                    d = 1.0 - Math.log1p(d3) * MathUtil.ONE_BY_LOG2;
                }
                d2 = 0.5 * (d3 + 3.0);
                int n = 1;
                while (true) {
                    double d7;
                    double d8;
                    double d9;
                    double d10;
                    double d11;
                    double d12 = Math.pow(2.0, -d);
                    double d13 = 1.0 - d12;
                    if (Math.abs((d -= ((d11 = (d10 = 1.0 - (d9 = Math.pow(3.0, -d))) / d13) - d2) / (d8 = (d13 * d9 * MathUtil.LOG3 - d10 * d12 * MathUtil.LOG2) / (d13 * d12))) - (d7 = d)) < 1.0E-20 * d) break;
                    if (n >= MAXIT) {
                        throw new ArithmeticException("Newton-Raphson did not converge.");
                    }
                    ++n;
                }
            }
        }
        d2 = Math.exp(GammaDistribution.logGamma(1.0 + d));
        double d14 = d;
        double d15 = dArray[1] * d / (d2 * (1.0 - Math.pow(2.0, -d)));
        double d16 = dArray[0] - d15 * (1.0 - d2) / d;
        return new GeneralizedExtremeValueDistribution(d16, d15, d14);
    }

    @Override
    public Class<? super GeneralizedExtremeValueDistribution> getDistributionClass() {
        return GeneralizedExtremeValueDistribution.class;
    }

    public static class Parameterizer
    extends AbstractParameterizer {
        @Override
        protected GeneralizedExtremeValueLMMEstimator makeInstance() {
            return STATIC;
        }
    }
}

