/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.persistent;

import de.lmu.ifi.dbs.elki.logging.Logging;
import de.lmu.ifi.dbs.elki.logging.LoggingUtil;
import de.lmu.ifi.dbs.elki.persistent.AbstractStoringPageFile;
import de.lmu.ifi.dbs.elki.persistent.OnDiskArray;
import de.lmu.ifi.dbs.elki.persistent.Page;
import de.lmu.ifi.dbs.elki.persistent.PageHeader;
import de.lmu.ifi.dbs.elki.utilities.io.ByteBufferInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import java.util.logging.Level;

public class OnDiskArrayPageFile<P extends Page>
extends AbstractStoringPageFile<P> {
    private static final Logging LOG = Logging.getLogger(OnDiskArrayPageFile.class);
    private static final int EMPTY_PAGE = 0;
    private static final int FILLED_PAGE = 1;
    private File filename;
    private OnDiskArray file;
    protected PageHeader header;
    private final boolean existed;

    public OnDiskArrayPageFile(int n, String string) {
        super(n);
        this.filename = new File(string);
        this.existed = this.filename.exists();
    }

    @Override
    public P readPage(int n) {
        try {
            this.countRead();
            return this.byteBufferToPage(this.file.getRecordBuffer(n));
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException occurred during reading of page " + n, iOException);
        }
    }

    @Override
    public void deletePage(int n) {
        try {
            super.deletePage(n);
            this.countWrite();
            byte[] byArray = this.pageToByteArray(null);
            this.file.getRecordBuffer(n).put(byArray);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public void writePage(int n, P p) {
        if (p.isDirty()) {
            try {
                this.countWrite();
                byte[] byArray = this.pageToByteArray(p);
                this.file.getRecordBuffer(n).put(byArray);
                p.setDirty(false);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    @Override
    public void close() {
        try {
            super.close();
            this.file.close();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    @Override
    public void clear() {
        try {
            this.file.resizeFile(0);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private P byteBufferToPage(ByteBuffer byteBuffer) {
        try (ByteBufferInputStream byteBufferInputStream = new ByteBufferInputStream(byteBuffer);){
            int n;
            Throwable throwable;
            ObjectInputStream objectInputStream;
            block34: {
                Page page;
                block35: {
                    block32: {
                        P p;
                        block33: {
                            objectInputStream = new ObjectInputStream(byteBufferInputStream);
                            throwable = null;
                            n = objectInputStream.readInt();
                            if (n != 0) break block32;
                            p = null;
                            if (objectInputStream == null) return p;
                            if (throwable == null) break block33;
                            try {
                                objectInputStream.close();
                                return p;
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                                return p;
                            }
                        }
                        objectInputStream.close();
                        return p;
                    }
                    if (n != 1) break block34;
                    page = (Page)objectInputStream.readObject();
                    if (objectInputStream == null) return (P)page;
                    if (throwable == null) break block35;
                    try {
                        objectInputStream.close();
                        return (P)page;
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                        return (P)page;
                    }
                }
                objectInputStream.close();
                return (P)page;
            }
            try {
                try {
                    throw new IllegalArgumentException("Unknown type: " + n);
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
            }
            catch (Throwable throwable5) {
                if (objectInputStream == null) throw throwable5;
                if (throwable == null) {
                    objectInputStream.close();
                    throw throwable5;
                }
                try {
                    objectInputStream.close();
                    throw throwable5;
                }
                catch (Throwable throwable6) {
                    throwable.addSuppressed(throwable6);
                    throw throwable5;
                }
            }
        }
        catch (IOException iOException) {
            LoggingUtil.exception(iOException);
            return null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            LoggingUtil.exception(classNotFoundException);
            return null;
        }
    }

    private byte[] pageToByteArray(P p) {
        try {
            if (p == null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeInt(0);
                objectOutputStream.close();
                byteArrayOutputStream.close();
                byte[] byArray = byteArrayOutputStream.toByteArray();
                byte[] byArray2 = new byte[this.pageSize];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                return byArray2;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeInt(1);
            objectOutputStream.writeObject(p);
            objectOutputStream.close();
            byteArrayOutputStream.close();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (byArray.length > this.pageSize) {
                throw new IllegalArgumentException("Size of page " + p + " is greater than specified" + " pagesize: " + byArray.length + " > " + this.pageSize);
            }
            if (byArray.length == this.pageSize) {
                return byArray;
            }
            byte[] byArray3 = new byte[this.pageSize];
            System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
            return byArray3;
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException occurred! ", iOException);
        }
    }

    @Override
    public boolean initialize(PageHeader pageHeader) {
        this.header = pageHeader;
        try {
            if (this.existed) {
                LoggingUtil.logExpensive(Level.INFO, "Create from existing file.");
                this.file = new OnDiskArray(this.filename, 0, pageHeader.size(), this.pageSize, true);
                ByteBuffer byteBuffer = this.file.getExtraHeader();
                Object object = new byte[byteBuffer.remaining()];
                byteBuffer.get((byte[])object);
                pageHeader.readHeader((byte[])object);
                for (int i = 0; i < this.file.getNumRecords(); ++i) {
                    object = this.file.getRecordBuffer(i);
                    int n = ((ByteBuffer)object).getInt();
                    if (n == 0) {
                        this.emptyPages.push(i);
                    } else if (n == 1) {
                        this.nextPageID = i + 1;
                    } else {
                        throw new IllegalArgumentException("Unknown type: " + n);
                    }
                    ++i;
                }
                return true;
            }
            LoggingUtil.logExpensive(Level.INFO, "Create a new file.");
            this.file = new OnDiskArray(this.filename, 0, pageHeader.size(), this.pageSize, 0);
            ByteBuffer byteBuffer = this.file.getExtraHeader();
            byteBuffer.put(pageHeader.asByteArray());
            return false;
        }
        catch (IOException iOException) {
            throw new RuntimeException("IOException occurred.", iOException);
        }
    }

    @Override
    protected Logging getLogger() {
        return LOG;
    }
}

