/*
 * Decompiled with CFR 0.152.
 */
package de.lmu.ifi.dbs.elki.database.query.range;

import de.lmu.ifi.dbs.elki.database.ids.DBIDIter;
import de.lmu.ifi.dbs.elki.database.ids.DBIDRef;
import de.lmu.ifi.dbs.elki.database.ids.DBIDUtil;
import de.lmu.ifi.dbs.elki.database.ids.DoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.ids.ModifiableDoubleDBIDList;
import de.lmu.ifi.dbs.elki.database.query.distance.PrimitiveDistanceQuery;
import de.lmu.ifi.dbs.elki.database.query.range.AbstractDistanceRangeQuery;
import de.lmu.ifi.dbs.elki.database.relation.Relation;
import de.lmu.ifi.dbs.elki.distance.distancefunction.PrimitiveDistanceFunction;

public class LinearScanPrimitiveDistanceRangeQuery<O>
extends AbstractDistanceRangeQuery<O> {
    private PrimitiveDistanceFunction<? super O> rawdist;

    public LinearScanPrimitiveDistanceRangeQuery(PrimitiveDistanceQuery<O> primitiveDistanceQuery) {
        super(primitiveDistanceQuery);
        this.rawdist = primitiveDistanceQuery.getDistanceFunction();
    }

    @Override
    public DoubleDBIDList getRangeForDBID(DBIDRef dBIDRef, double d) {
        Object o = this.relation.get(dBIDRef);
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList();
        this.linearScan(this.relation, this.relation.iterDBIDs(), o, d, modifiableDoubleDBIDList);
        modifiableDoubleDBIDList.sort();
        return modifiableDoubleDBIDList;
    }

    @Override
    public DoubleDBIDList getRangeForObject(O o, double d) {
        ModifiableDoubleDBIDList modifiableDoubleDBIDList = DBIDUtil.newDistanceDBIDList();
        this.linearScan(this.relation, this.relation.iterDBIDs(), o, d, modifiableDoubleDBIDList);
        modifiableDoubleDBIDList.sort();
        return modifiableDoubleDBIDList;
    }

    @Override
    public void getRangeForDBID(DBIDRef dBIDRef, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
        this.linearScan(this.relation, this.relation.iterDBIDs(), this.relation.get(dBIDRef), d, modifiableDoubleDBIDList);
    }

    @Override
    public void getRangeForObject(O o, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
        this.linearScan(this.relation, this.relation.iterDBIDs(), o, d, modifiableDoubleDBIDList);
    }

    private void linearScan(Relation<? extends O> relation, DBIDIter dBIDIter, O o, double d, ModifiableDoubleDBIDList modifiableDoubleDBIDList) {
        while (dBIDIter.valid()) {
            double d2 = this.rawdist.distance(o, relation.get(dBIDIter));
            if (d2 <= d) {
                modifiableDoubleDBIDList.add(d2, dBIDIter);
            }
            dBIDIter.advance();
        }
    }
}

