/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.eol.execute.operations.contributors;

import org.eclipse.epsilon.eol.execute.operations.contributors.OperationContributor;
import org.eclipse.epsilon.eol.types.NumberUtil;

public class NumberOperationContributor
extends OperationContributor {
    @Override
    public boolean contributesTo(Object target) {
        return target instanceof Number;
    }

    private Number getNumber() {
        return (Number)this.target;
    }

    public Number min(Number other) {
        Number self = (Number)this.target;
        if (NumberUtil.lessThan(self, other)) {
            return self;
        }
        return other;
    }

    public Number max(Number other) {
        Number self = (Number)this.target;
        if (NumberUtil.greaterThan(self, other)) {
            return self;
        }
        return other;
    }

    public int floor() {
        Number self = (Number)this.target;
        return (int)Math.floor(self.doubleValue());
    }

    public Number pow(Number n) {
        Double pow = Math.pow(((Number)this.target).doubleValue(), n.doubleValue());
        if (this.target instanceof Integer && n instanceof Integer && NumberUtil.greaterThan(n, 0)) {
            return pow.intValue();
        }
        return pow;
    }

    public int ceiling() {
        Number self = (Number)this.target;
        return (int)Math.ceil(self.doubleValue());
    }

    public int round() {
        return Math.round(this.getNumber().floatValue());
    }

    public double ln() {
        return this.log();
    }

    public double log() {
        return Math.log(this.getNumber().doubleValue());
    }

    public double log10(Number n) {
        return Math.log10(this.getNumber().doubleValue());
    }

    public Number abs() {
        if (this.target instanceof Integer) {
            return Math.abs((Integer)this.target);
        }
        if (this.target instanceof Float) {
            return Float.valueOf(Math.abs(((Float)this.target).floatValue()));
        }
        if (this.target instanceof Double) {
            return Math.abs((Double)this.target);
        }
        if (this.target instanceof Long) {
            return Math.abs((Long)this.target);
        }
        return null;
    }

    public double asReal() {
        Number value = (Number)this.target;
        return value.floatValue();
    }

    public double asDouble() {
        Number value = (Number)this.target;
        return value.doubleValue();
    }

    public float asFloat() {
        Number value = (Number)this.target;
        return value.floatValue();
    }

    public int asInteger() {
        Number value = (Number)this.target;
        return value.intValue();
    }

    public long asLong() {
        Number value = (Number)this.target;
        return value.longValue();
    }
}

