/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.io.ByteStreamLogger;
import org.apache.logging.log4j.spi.ExtendedLogger;

public class LoggerFilterOutputStream
extends FilterOutputStream {
    private static final String FQCN = LoggerFilterOutputStream.class.getName();
    private final ByteStreamLogger logger;
    private final String fqcn;

    protected LoggerFilterOutputStream(OutputStream out, Charset charset, ExtendedLogger logger, String fqcn, Level level, Marker marker) {
        super(out);
        this.logger = new ByteStreamLogger(logger, level, marker, charset);
        this.fqcn = fqcn == null ? FQCN : fqcn;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
        this.logger.close(this.fqcn);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    public String toString() {
        return LoggerFilterOutputStream.class.getSimpleName() + "{stream=" + this.out + '}';
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.out.write(b);
        this.logger.put(this.fqcn, b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        this.logger.put(this.fqcn, b, off, len);
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        this.logger.put(this.fqcn, (byte)(b & 0xFF));
    }
}

