/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.egl.formatter;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import org.eclipse.epsilon.egl.formatter.Formatter;

public class CompositeFormatter
implements Formatter {
    private final Collection<Formatter> formatters;

    public CompositeFormatter(Formatter ... formatters) {
        this(Arrays.asList(formatters));
    }

    public CompositeFormatter(Collection<Formatter> formatters) {
        this.formatters = new LinkedList<Formatter>(formatters);
    }

    @Override
    public String format(String text) {
        String current = text;
        for (Formatter formatter : this.formatters) {
            current = formatter.format(current);
        }
        return current;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CompositeFormatter)) {
            return false;
        }
        CompositeFormatter other = (CompositeFormatter)obj;
        return this.formatters.equals(other.formatters);
    }

    public int hashCode() {
        return this.formatters.hashCode();
    }
}

