/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.emc.composite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.epsilon.ecl.trace.Match;
import org.eclipse.epsilon.ecl.trace.MatchTrace;
import org.eclipse.epsilon.eol.exceptions.EolIllegalPropertyException;
import org.eclipse.epsilon.eol.exceptions.EolRuntimeException;
import org.eclipse.epsilon.eol.exceptions.models.EolEnumerationValueNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelElementTypeNotFoundException;
import org.eclipse.epsilon.eol.exceptions.models.EolModelLoadingException;
import org.eclipse.epsilon.eol.exceptions.models.EolNotInstantiableModelElementTypeException;
import org.eclipse.epsilon.eol.execute.introspection.AbstractPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.AbstractPropertySetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertyGetter;
import org.eclipse.epsilon.eol.execute.introspection.IPropertySetter;
import org.eclipse.epsilon.eol.models.IModel;
import org.eclipse.epsilon.eol.models.Model;

public class CompositeModel
extends Model {
    protected Collection<IModel> models = new ArrayList<IModel>();
    protected ArrayList<ArrayList<Object>> equivalents = new ArrayList();

    public CompositeModel(Collection<IModel> models) {
        this.models = models;
    }

    public CompositeModel(String name, Collection<IModel> models) {
        this(models);
        this.setName(name);
    }

    public CompositeModel(Collection<IModel> models, MatchTrace matchTrace) {
        this.models = models;
        this.findEquivalents(matchTrace.getReduced());
    }

    protected void findEquivalents(MatchTrace matchTrace) {
        for (Match m : matchTrace.getMatches()) {
            ArrayList<Object> eq2;
            boolean existing = false;
            for (ArrayList<Object> eq2 : this.equivalents) {
                if (!eq2.contains(m.getLeft()) && !eq2.contains(m.getRight())) continue;
                existing = true;
                if (!eq2.contains(m.getLeft())) {
                    eq2.add(m.getLeft());
                }
                if (eq2.contains(m.getRight())) continue;
                eq2.add(m.getRight());
            }
            if (existing) continue;
            eq2 = new ArrayList();
            eq2.add(m.getLeft());
            eq2.add(m.getRight());
            this.equivalents.add(eq2);
        }
    }

    public Collection<Object> getEquivalents(Object instance) {
        ArrayList<Object> equivalents = new ArrayList<Object>();
        for (ArrayList<Object> eq : this.equivalents) {
            if (!eq.contains(instance)) continue;
            equivalents.addAll(eq);
        }
        return equivalents;
    }

    public void removeDuplicates(Collection<Object> original, Collection<Object> equivalents) {
        for (Object eq : equivalents) {
            if (!original.contains(eq)) continue;
            for (Object rem : equivalents) {
                if (rem == eq) continue;
                original.remove(rem);
            }
        }
    }

    protected void removeDuplicates(Collection<Object> original) {
        for (ArrayList<Object> eq : this.equivalents) {
            this.removeDuplicates(original, eq);
        }
    }

    @Override
    public Collection<?> allContents() {
        ArrayList<Object> all = new ArrayList<Object>();
        for (IModel m : this.models) {
            all.addAll(m.allContents());
        }
        this.removeDuplicates(all);
        return all;
    }

    @Override
    public Object createInstance(String type) throws EolModelElementTypeNotFoundException, EolNotInstantiableModelElementTypeException {
        for (IModel m : this.models) {
            if (!m.hasType(type)) continue;
            return m.createInstance(type);
        }
        throw new EolNotInstantiableModelElementTypeException(this.name, type);
    }

    @Override
    public void deleteElement(Object instance) throws EolRuntimeException {
        for (IModel m : this.models) {
            if (!m.owns(instance)) continue;
            m.deleteElement(instance);
        }
    }

    public Collection<Object> getAllOfKind(String type) throws EolModelElementTypeNotFoundException {
        ArrayList<Object> all = new ArrayList<Object>();
        for (IModel m : this.models) {
            if (!m.hasType(type)) continue;
            all.addAll(m.getAllOfKind(type));
        }
        this.removeDuplicates(all);
        return all;
    }

    public Collection<Object> getAllOfType(String type) throws EolModelElementTypeNotFoundException {
        ArrayList<Object> all = new ArrayList<Object>();
        for (IModel m : this.models) {
            if (!m.hasType(type)) continue;
            all.addAll(m.getAllOfType(type));
        }
        this.removeDuplicates(all);
        return all;
    }

    @Override
    public Object getElementById(String id) {
        for (IModel m : this.models) {
            Object element = null;
            element = m.getElementById(id);
            if (element == null) continue;
            return element;
        }
        return null;
    }

    @Override
    public String getElementId(Object instance) {
        for (IModel m : this.models) {
            if (!m.owns(instance)) continue;
            return m.getElementId(instance);
        }
        return null;
    }

    @Override
    public void setElementId(Object instance, String newId) {
        for (IModel m : this.models) {
            if (!m.owns(instance)) continue;
            m.setElementId(instance, newId);
        }
    }

    @Override
    public Object getEnumerationValue(String enumeration, String label) throws EolEnumerationValueNotFoundException {
        if (this.models.size() > 0) {
            return this.models.iterator().next().getEnumerationValue(enumeration, label);
        }
        return null;
    }

    @Override
    public Object getTypeOf(Object instance) {
        for (IModel m : this.models) {
            if (!m.owns(instance)) continue;
            return m.getTypeOf(instance);
        }
        return false;
    }

    @Override
    public String getTypeNameOf(Object instance) {
        for (IModel m : this.models) {
            if (!m.isModelElement(instance)) continue;
            return m.getTypeNameOf(instance);
        }
        throw new IllegalArgumentException("Cannot be contained by this model: " + instance);
    }

    @Override
    public boolean hasType(String type) {
        for (IModel m : this.models) {
            if (!m.hasType(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInstantiable(String type) {
        return false;
    }

    @Override
    public boolean isModelElement(Object instance) {
        for (IModel m : this.models) {
            if (!m.isModelElement(instance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void load() throws EolModelLoadingException {
    }

    @Override
    public boolean owns(Object instance) {
        for (IModel m : this.models) {
            if (!m.owns(instance)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void dispose() {
        for (IModel m : this.models) {
            m.dispose();
        }
        super.dispose();
    }

    @Override
    public boolean store(String location) {
        for (IModel m : this.models) {
            if (m.store(location)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean store() {
        for (IModel m : this.models) {
            if (m.store()) continue;
            return false;
        }
        return true;
    }

    @Override
    public IPropertyGetter getPropertyGetter() {
        return new CompositePropertyGetter();
    }

    @Override
    public IPropertySetter getPropertySetter() {
        return new CompositePropertySetter();
    }

    class CompositePropertyGetter
    extends AbstractPropertyGetter {
        CompositePropertyGetter() {
        }

        @Override
        public Object invoke(Object object, String property) throws EolRuntimeException {
            HashMap<Object, IPropertyGetter> getters = new HashMap<Object, IPropertyGetter>();
            Collection<Object> equivalents = CompositeModel.this.getEquivalents(object);
            if (equivalents.isEmpty()) {
                equivalents.add(object);
            }
            for (Object equivalent : equivalents) {
                for (IModel model : CompositeModel.this.models) {
                    if (!model.owns(equivalent)) continue;
                    getters.put(equivalent, model.getPropertyGetter());
                }
            }
            HashSet<Object> results = new HashSet<Object>();
            for (Object eq : equivalents) {
                Object result = ((IPropertyGetter)getters.get(eq)).invoke(eq, property);
                if (result instanceof Collection) {
                    results.addAll((Collection)result);
                    continue;
                }
                return result;
            }
            CompositeModel.this.removeDuplicates(results);
            return results;
        }
    }

    private class CompositePropertySetter
    extends AbstractPropertySetter {
        private CompositePropertySetter() {
        }

        @Override
        public void invoke(Object value) throws EolRuntimeException {
            this.getDelegate().invoke(value);
        }

        private IPropertySetter getDelegate() throws EolIllegalPropertyException {
            for (IModel model : CompositeModel.this.models) {
                if (!model.owns(this.object)) continue;
                IPropertySetter delegate = model.getPropertySetter();
                delegate.setAst(this.ast);
                delegate.setContext(this.context);
                delegate.setObject(this.object);
                delegate.setProperty(this.property);
                return delegate;
            }
            throw new EolIllegalPropertyException(this.object, this.property, this.ast, this.context);
        }
    }
}

