/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.unparser.internal;

import org.eclipse.epsilon.hutn.model.hutn.ClassObject;
import org.eclipse.epsilon.hutn.model.hutn.PackageObject;
import org.eclipse.epsilon.hutn.unparser.internal.ClassObjectUnparser;
import org.eclipse.epsilon.hutn.unparser.internal.Unparser;

class PackageObjectUnparser
extends Unparser {
    private final PackageObject packageObject;

    public PackageObjectUnparser(PackageObject packageObject) {
        this.packageObject = packageObject;
    }

    public PackageObjectUnparser(PackageObject packageObject, StringBuilder builder) {
        super(builder);
        this.packageObject = packageObject;
    }

    @Override
    protected void doUnparse() {
        this.appendSignature(this.packageObject);
        this.appendSpace();
        this.unparseClassObjects();
    }

    private void unparseClassObjects() {
        this.builder.append('{');
        for (ClassObject classObject : this.packageObject.getClassObjects()) {
            this.unparseClassObject(classObject);
        }
        this.builder.append('}');
    }

    private void unparseClassObject(ClassObject classObject) {
        new ClassObjectUnparser(classObject, this.builder).unparse();
        this.appendNewLine();
    }
}

