/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epsilon.hutn.xmi.coerce;

import org.eclipse.emf.common.util.EList;
import org.eclipse.epsilon.emc.emf.util.EListUtil;
import org.eclipse.epsilon.hutn.model.hutn.AttributeSlot;
import org.eclipse.epsilon.hutn.model.hutn.Slot;
import org.eclipse.epsilon.hutn.xmi.coerce.PrimitiveCoercionStrategy;
import org.eclipse.epsilon.hutn.xmi.coerce.ReferenceCoercionStrategy;

public abstract class AbstractCoercionStrategy {
    protected final AttributeSlot slot;
    protected final EList<String> values;

    public AbstractCoercionStrategy(AttributeSlot slot) {
        this.slot = slot;
        this.values = EListUtil.castElements(slot.getValues(), String.class);
    }

    public abstract boolean isApplicable();

    public abstract Slot<?> coerce();

    public static AbstractCoercionStrategy getCoercerFor(AttributeSlot slot) {
        if (new ReferenceCoercionStrategy(slot).isApplicable()) {
            return new ReferenceCoercionStrategy(slot);
        }
        return new PrimitiveCoercionStrategy(slot);
    }
}

