/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.algorithm.multiobjective.spea2.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.uma.jmetal.operator.SelectionOperator;
import org.uma.jmetal.solution.Solution;
import org.uma.jmetal.util.SolutionListUtils;
import org.uma.jmetal.util.comparator.StrengthFitnessComparator;
import org.uma.jmetal.util.solutionattribute.impl.LocationAttribute;
import org.uma.jmetal.util.solutionattribute.impl.StrengthRawFitness;

public class EnvironmentalSelection<S extends Solution<?>>
implements SelectionOperator<List<S>, List<S>> {
    private int solutionsToSelect = 0;
    private final StrengthRawFitness<S> strengthRawFitness = new StrengthRawFitness();

    public EnvironmentalSelection(int solutionsToSelect) {
        this.solutionsToSelect = solutionsToSelect;
    }

    @Override
    public List<S> execute(List<S> source2) {
        ArrayList<S> source = new ArrayList<S>(source2.size());
        source.addAll(source2);
        int size = source2.size() < this.solutionsToSelect ? source.size() : this.solutionsToSelect;
        ArrayList aux = new ArrayList(source.size());
        int i = 0;
        while (i < source.size()) {
            double fitness = (Double)this.strengthRawFitness.getAttribute((Solution)source.get(i));
            if (fitness < 1.0) {
                aux.add(source.get(i));
                source.remove(i);
                continue;
            }
            ++i;
        }
        if (aux.size() < size) {
            StrengthFitnessComparator comparator = new StrengthFitnessComparator();
            Collections.sort(source, comparator);
            int remain = size - aux.size();
            for (i = 0; i < remain; ++i) {
                aux.add(source.get(i));
            }
            return aux;
        }
        if (aux.size() == size) {
            return aux;
        }
        double[][] distance = SolutionListUtils.distanceMatrix(aux);
        ArrayList distanceList = new ArrayList();
        LocationAttribute location = new LocationAttribute(aux);
        for (int pos = 0; pos < aux.size(); ++pos) {
            ArrayList<Pair<Integer, Double>> distanceNodeList = new ArrayList<Pair<Integer, Double>>();
            for (int ref = 0; ref < aux.size(); ++ref) {
                if (pos == ref) continue;
                distanceNodeList.add(Pair.of(ref, distance[pos][ref]));
            }
            distanceList.add(distanceNodeList);
        }
        for (int q = 0; q < distanceList.size(); ++q) {
            Collections.sort((List)distanceList.get(q), new Comparator<Pair<Integer, Double>>(){

                @Override
                public int compare(Pair<Integer, Double> pair1, Pair<Integer, Double> pair2) {
                    if (pair1.getRight() < pair2.getRight()) {
                        return -1;
                    }
                    if (pair1.getRight() > pair2.getRight()) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        while (aux.size() > size) {
            double minDistance = Double.MAX_VALUE;
            int toRemove = 0;
            i = 0;
            for (List list : distanceList) {
                if ((Double)((Pair)list.get(0)).getRight() < minDistance) {
                    toRemove = i;
                    minDistance = (Double)((Pair)list.get(0)).getRight();
                } else if ((Double)((Pair)list.get(0)).getRight() == minDistance) {
                    int k;
                    for (k = 0; ((Pair)list.get(k)).getRight() == ((Pair)((List)distanceList.get(toRemove)).get(k)).getRight() && k < ((List)distanceList.get(i)).size() - 1; ++k) {
                    }
                    if ((Double)((Pair)list.get(k)).getRight() < (Double)((Pair)((List)distanceList.get(toRemove)).get(k)).getRight()) {
                        toRemove = i;
                    }
                }
                ++i;
            }
            int n = (Integer)location.getAttribute((Solution)aux.get(toRemove));
            aux.remove(toRemove);
            distanceList.remove(toRemove);
            Iterator externIterator = distanceList.iterator();
            while (externIterator.hasNext()) {
                Iterator interIterator = ((List)externIterator.next()).iterator();
                while (interIterator.hasNext()) {
                    if ((Integer)((Pair)interIterator.next()).getLeft() != n) continue;
                    interIterator.remove();
                }
            }
        }
        return aux;
    }
}

