/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.cec2015OptBigDataCompetition;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;

public class BigOpt2015
extends AbstractDoubleProblem {
    private List<List<Double>> mixed;
    private List<List<Double>> matrixA;
    private List<List<Double>> icaComponent;
    double f1max = -1000000.0;
    double f2max = -1000000.0;
    double f1min = 1.0E7;
    double f2min = 1.0E7;
    int dTypeG;
    boolean scaling;

    public BigOpt2015(String instanceName) {
        this.loadData(instanceName);
        this.scaling = false;
        this.setNumberOfVariables(this.dTypeG * 256);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(0);
        this.setName("BigOpt2015");
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(-8.0);
            upperLimit.add(8.0);
        }
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        ArrayList<List<Double>> s1 = new ArrayList<List<Double>>();
        for (int i = 0; i < this.dTypeG; ++i) {
            ArrayList s1Temp = new ArrayList();
            for (int j = 0; j < this.icaComponent.get(0).size(); ++j) {
                s1Temp.add(solution.getVariableValue(i * this.icaComponent.get(0).size() + j));
            }
            s1.add(s1Temp);
        }
        List<List<Double>> x1 = this.multiplyWithOutAMP(this.matrixA, s1);
        List<List<Double>> cor1 = this.correlation(x1, this.mixed);
        double sum = 0.0;
        for (int i = 0; i < this.icaComponent.size(); ++i) {
            for (int j = 0; j < this.icaComponent.get(i).size(); ++j) {
                sum += Math.pow(this.icaComponent.get(i).get(j) - (Double)((List)s1.get(i)).get(j), 2.0);
            }
        }
        double obj1 = this.diagonal1(cor1) + this.diagonal2(cor1);
        double obj2 = sum / (double)(this.icaComponent.size() * this.icaComponent.get(0).size());
        if (obj1 > this.f1max) {
            this.f1max = obj1;
        }
        if (obj1 < this.f1min) {
            this.f1min = obj1;
        }
        if (obj2 > this.f1max) {
            this.f1max = obj2;
        }
        if (obj2 < this.f1min) {
            this.f1min = obj2;
        }
        if (this.scaling) {
            obj2 = (obj2 - this.f2min) * (this.f1max - this.f1min) / (this.f2max - this.f2min) + this.f1min;
        }
        solution.setObjective(0, obj1);
        solution.setObjective(1, obj2);
    }

    private void loadData(String problemId, String fName, int dType, int dLength) {
        String fileName = "/cec2015Comp/" + problemId + fName;
        InputStream inputStream = this.createInputStream(fileName);
        InputStreamReader isr = new InputStreamReader(inputStream);
        BufferedReader br = new BufferedReader(isr);
        ArrayList<List<Double>> list = new ArrayList<List<Double>>();
        try {
            String aux = br.readLine();
            while (aux != null) {
                StringTokenizer tokenizer = new StringTokenizer(aux);
                ArrayList<Double> doubleList = new ArrayList<Double>();
                while (tokenizer.hasMoreTokens()) {
                    double value = new Double(tokenizer.nextToken());
                    doubleList.add(value);
                }
                list.add(doubleList);
                aux = br.readLine();
            }
            br.close();
        }
        catch (IOException e) {
            throw new JMetalException("Error reading file", e);
        }
        catch (NumberFormatException e) {
            throw new JMetalException("Format number exception when reading file", e);
        }
        if (fName.equals("X.txt")) {
            this.mixed = list;
        } else if (fName.equals("S.txt")) {
            this.icaComponent = list;
        } else if (fName.equals("A.txt")) {
            this.matrixA = list;
        } else {
            throw new JMetalException("Wrong name: " + fName);
        }
    }

    private void loadData(String problemId) {
        int dType = 4;
        if (problemId.equals("D4")) {
            dType = 4;
        } else if (problemId.equals("D4N")) {
            dType = 4;
        } else if (problemId.equals("D12")) {
            dType = 12;
        } else if (problemId.equals("D12N")) {
            dType = 12;
        } else if (problemId.equals("D19")) {
            dType = 19;
        } else if (problemId.equals("D19N")) {
            dType = 19;
        }
        this.dTypeG = dType;
        this.loadData(problemId, "X.txt", dType, 256);
        this.loadData(problemId, "S.txt", dType, 256);
        this.loadData(problemId, "A.txt", dType, dType);
    }

    private InputStream createInputStream(String fileName) {
        InputStream inputStream = this.getClass().getResourceAsStream(fileName);
        return inputStream;
    }

    List<Double> newMeanStandardDeviation(List<Double> list) {
        ArrayList<Double> result = new ArrayList<Double>();
        double sum = 0.0;
        for (double value : list) {
            sum += value;
        }
        double mean = sum / (double)list.size();
        double accum = 0.0;
        for (double value : list) {
            accum += (value - mean) * (value - mean);
        }
        double stdev = Math.sqrt(accum / (double)(list.size() - 1));
        result.add(mean);
        result.add(stdev);
        return result;
    }

    double vectorCorrelation(List<Double> list1, List<Double> list2) {
        List<Double> a1 = this.newMeanStandardDeviation(list1);
        List<Double> b1 = this.newMeanStandardDeviation(list2);
        double c1 = 0.0;
        double a = a1.get(1) * b1.get(1);
        if (Math.abs(a) > 1.0E-5) {
            for (int i = 0; i < list1.size(); ++i) {
                double temp1 = list1.get(i) - list1.get(0);
                double temp2 = list2.get(i) - list2.get(0);
                c1 += temp1 * temp2;
            }
            return c1 /= (double)list1.size() * a;
        }
        return 0.0;
    }

    List<List<Double>> correlation(List<List<Double>> list1, List<List<Double>> list2) {
        ArrayList<List<Double>> m = new ArrayList<List<Double>>();
        for (List<Double> i : list1) {
            ArrayList<Double> temp = new ArrayList<Double>();
            for (List<Double> j : list2) {
                temp.add(this.vectorCorrelation(i, j));
            }
            m.add(temp);
        }
        return m;
    }

    double diagonal1(List<List<Double>> list) {
        double sum = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 0; j < list.size(); ++j) {
                if (i != j) continue;
                sum += Math.pow(1.0 - list.get(i).get(j), 2.0);
            }
        }
        return sum / (double)list.size();
    }

    double diagonal2(List<List<Double>> list) {
        double sum = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            for (int j = 0; j < list.size(); ++j) {
                if (i == j) continue;
                sum += Math.pow(list.get(i).get(j), 2.0);
            }
        }
        return sum / (double)list.size() / (double)(list.size() - 1);
    }

    List<List<Double>> multiplyWithOutAMP(List<List<Double>> list1, List<List<Double>> list2) {
        int col;
        int row;
        ArrayList<List<Double>> c = new ArrayList<List<Double>>();
        for (row = 0; row < list1.size(); ++row) {
            ArrayList<Double> cTemp = new ArrayList<Double>();
            for (col = 0; col < list2.get(0).size(); ++col) {
                cTemp.add(0.0);
            }
            c.add(cTemp);
        }
        for (row = 0; row < list1.size(); ++row) {
            for (col = 0; col < list2.get(row).size(); ++col) {
                for (int inner = 0; inner < list1.get(0).size(); ++inner) {
                    double val = (Double)((List)c.get(row)).get(col);
                    ((List)c.get(row)).set(col, val + list1.get(row).get(inner) * list2.get(inner).get(col));
                }
            }
        }
        return c;
    }
}

