/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.lz09;

import java.util.ArrayList;
import java.util.List;

public class LZ09 {
    int nvar;
    int nobj;
    int ltype;
    int dtype;
    int ptype;

    public LZ09(int nvar, int nobj, int ptype, int dtype, int ltype) {
        this.nvar = nvar;
        this.nobj = nobj;
        this.ltype = ltype;
        this.dtype = dtype;
        this.ptype = ptype;
    }

    void alphaFunction(double[] alpha, List<Double> x, int dim, int type) {
        if (dim == 2) {
            if (type == 21) {
                alpha[0] = x.get(0);
                alpha[1] = 1.0 - Math.sqrt(x.get(0));
            }
            if (type == 22) {
                alpha[0] = x.get(0);
                alpha[1] = 1.0 - x.get(0) * x.get(0);
            }
            if (type == 23) {
                alpha[0] = x.get(0);
                alpha[1] = 1.0 - Math.sqrt(alpha[0]) - alpha[0] * Math.sin(10.0 * alpha[0] * alpha[0] * Math.PI);
            }
            if (type == 24) {
                alpha[0] = x.get(0);
                alpha[1] = 1.0 - x.get(0) - 0.05 * Math.sin(Math.PI * 4 * x.get(0));
            }
        } else {
            if (type == 31) {
                alpha[1] = Math.cos(x.get(0) * Math.PI / 2.0) * Math.sin(x.get(1) * Math.PI / 2.0);
                alpha[2] = Math.sin(x.get(0) * Math.PI / 2.0);
            }
            if (type == 32) {
                alpha[0] = 1.0 - Math.cos(x.get(0) * Math.PI / 2.0) * Math.cos(x.get(1) * Math.PI / 2.0);
                alpha[1] = 1.0 - Math.cos(x.get(0) * Math.PI / 2.0) * Math.sin(x.get(1) * Math.PI / 2.0);
                alpha[2] = 1.0 - Math.sin(x.get(0) * Math.PI / 2.0);
            }
            if (type == 33) {
                alpha[0] = x.get(0);
                alpha[1] = x.get(1);
                alpha[2] = 3.0 - (Math.sin(Math.PI * 3 * x.get(0)) + Math.sin(Math.PI * 3 * x.get(1))) - 2.0 * (x.get(0) + x.get(1));
            }
            if (type == 34) {
                alpha[0] = x.get(0) * x.get(1);
                alpha[1] = x.get(0) * (1.0 - x.get(1));
                alpha[2] = 1.0 - x.get(0);
            }
        }
    }

    double betaFunction(List<Double> x, int type) {
        int i;
        double beta = 0.0;
        int dim = x.size();
        if (dim == 0) {
            beta = 0.0;
        }
        if (type == 1) {
            beta = 0.0;
            for (i = 0; i < dim; ++i) {
                beta += x.get(i) * x.get(i);
            }
            beta = 2.0 * beta / (double)dim;
        }
        if (type == 2) {
            beta = 0.0;
            for (i = 0; i < dim; ++i) {
                beta += Math.sqrt(i + 1) * x.get(i) * x.get(i);
            }
            beta = 2.0 * beta / (double)dim;
        }
        if (type == 3) {
            double sum = 0.0;
            for (int i2 = 0; i2 < dim; ++i2) {
                double xx = 2.0 * x.get(i2);
                sum += xx * xx - Math.cos(Math.PI * 4 * xx) + 1.0;
            }
            beta = 2.0 * sum / (double)dim;
        }
        if (type == 4) {
            double sum = 0.0;
            double prod = 1.0;
            for (int i3 = 0; i3 < dim; ++i3) {
                double xx = 2.0 * x.get(i3);
                sum += xx * xx;
                prod *= Math.cos(Math.PI * 10 * xx / Math.sqrt(i3 + 1));
            }
            beta = 2.0 * (sum - 2.0 * prod + 2.0) / (double)dim;
        }
        return beta;
    }

    double psfunc2(double x, double t1, int dim, int type, int css) {
        double xy;
        double ra;
        double xy2;
        double theta;
        double beta = 0.0;
        ++dim;
        if (type == 21) {
            double xy3 = 2.0 * (x - 0.5);
            beta = xy3 - Math.pow(t1, 0.5 * (double)(this.nvar + 3 * dim - 8) / (double)(this.nvar - 2));
        }
        if (type == 22) {
            theta = Math.PI * 6 * t1 + (double)dim * Math.PI / (double)this.nvar;
            xy2 = 2.0 * (x - 0.5);
            beta = xy2 - Math.sin(theta);
        }
        if (type == 23) {
            theta = Math.PI * 6 * t1 + (double)dim * Math.PI / (double)this.nvar;
            ra = 0.8 * t1;
            xy = 2.0 * (x - 0.5);
            beta = css == 1 ? xy - ra * Math.cos(theta) : xy - ra * Math.sin(theta);
        }
        if (type == 24) {
            theta = Math.PI * 6 * t1 + (double)dim * Math.PI / (double)this.nvar;
            xy2 = 2.0 * (x - 0.5);
            double ra2 = 0.8 * t1;
            beta = css == 1 ? xy2 - ra2 * Math.cos(theta / 3.0) : xy2 - ra2 * Math.sin(theta);
        }
        if (type == 25) {
            double rho = 0.8;
            double phi = Math.PI * t1;
            double theta2 = Math.PI * 6 * t1 + (double)dim * Math.PI / (double)this.nvar;
            double xy4 = 2.0 * (x - 0.5);
            beta = css == 1 ? xy4 - rho * Math.sin(phi) * Math.sin(theta2) : (css == 2 ? xy4 - rho * Math.sin(phi) * Math.cos(theta2) : xy4 - rho * Math.cos(phi));
        }
        if (type == 26) {
            theta = Math.PI * 6 * t1 + (double)dim * Math.PI / (double)this.nvar;
            ra = 0.3 * t1 * (t1 * Math.cos(4.0 * theta) + 2.0);
            xy = 2.0 * (x - 0.5);
            beta = css == 1 ? xy - ra * Math.cos(theta) : xy - ra * Math.sin(theta);
        }
        return beta;
    }

    double psfunc3(double x, double t1, double t2, int dim, int type) {
        double beta = 0.0;
        ++dim;
        if (type == 31) {
            double xy = 4.0 * (x - 0.5);
            double rate = 1.0 * (double)dim / (double)this.nvar;
            beta = xy - 4.0 * (t1 * t1 * rate + t2 * (1.0 - rate)) + 2.0;
        }
        if (type == 32) {
            double theta = Math.PI * 2 * t1 + (double)dim * Math.PI / (double)this.nvar;
            double xy = 4.0 * (x - 0.5);
            beta = xy - 2.0 * t2 * Math.sin(theta);
        }
        return beta;
    }

    void objective(List<Double> xVar, List<Double> yObj) {
        ArrayList<Double> bb;
        ArrayList<Double> aa;
        double h;
        double g;
        if (this.nobj == 2) {
            double b;
            double a;
            if (this.ltype == 21 || this.ltype == 22 || this.ltype == 23 || this.ltype == 24 || this.ltype == 26) {
                g = 0.0;
                h = 0.0;
                aa = new ArrayList<Double>();
                bb = new ArrayList<Double>();
                for (int n = 1; n < this.nvar; ++n) {
                    if (n % 2 == 0) {
                        a = this.psfunc2(xVar.get(n), xVar.get(0), n, this.ltype, 1);
                        aa.add(a);
                        continue;
                    }
                    b = this.psfunc2(xVar.get(n), xVar.get(0), n, this.ltype, 2);
                    bb.add(b);
                }
                g = this.betaFunction(aa, this.dtype);
                h = this.betaFunction(bb, this.dtype);
                double[] alpha = new double[2];
                this.alphaFunction(alpha, xVar, 2, this.ptype);
                yObj.set(0, alpha[0] + h);
                yObj.set(1, alpha[1] + g);
                aa.clear();
                bb.clear();
            }
            if (this.ltype == 25) {
                g = 0.0;
                h = 0.0;
                ArrayList<Double> aa2 = new ArrayList<Double>();
                ArrayList<Double> bb2 = new ArrayList<Double>();
                for (int n = 1; n < this.nvar; ++n) {
                    if (n % 3 == 0) {
                        a = this.psfunc2(xVar.get(n), xVar.get(0), n, this.ltype, 1);
                        aa2.add(a);
                        continue;
                    }
                    if (n % 3 == 1) {
                        b = this.psfunc2(xVar.get(n), xVar.get(0), n, this.ltype, 2);
                        bb2.add(b);
                        continue;
                    }
                    double c = this.psfunc2(xVar.get(n), xVar.get(0), n, this.ltype, 3);
                    if (n % 2 == 0) {
                        aa2.add(c);
                        continue;
                    }
                    bb2.add(c);
                }
                g = this.betaFunction(aa2, this.dtype);
                h = this.betaFunction(bb2, this.dtype);
                double[] alpha = new double[2];
                this.alphaFunction(alpha, xVar, 2, this.ptype);
                yObj.set(0, alpha[0] + h);
                yObj.set(1, alpha[1] + g);
                aa2.clear();
                bb2.clear();
            }
        }
        if (this.nobj == 3 && (this.ltype == 31 || this.ltype == 32)) {
            g = 0.0;
            h = 0.0;
            double e = 0.0;
            aa = new ArrayList();
            bb = new ArrayList();
            ArrayList<Double> cc = new ArrayList<Double>();
            for (int n = 2; n < this.nvar; ++n) {
                double a = this.psfunc3(xVar.get(n), xVar.get(0), xVar.get(1), n, this.ltype);
                if (n % 3 == 0) {
                    aa.add(a);
                    continue;
                }
                if (n % 3 == 1) {
                    bb.add(a);
                    continue;
                }
                cc.add(a);
            }
            g = this.betaFunction(aa, this.dtype);
            h = this.betaFunction(bb, this.dtype);
            e = this.betaFunction(cc, this.dtype);
            double[] alpha = new double[3];
            this.alphaFunction(alpha, xVar, 3, this.ptype);
            yObj.set(0, alpha[0] + h);
            yObj.set(1, alpha[1] + g);
            yObj.set(2, alpha[2] + e);
            aa.clear();
            bb.clear();
            cc.clear();
        }
    }
}

