/*
 * Decompiled with CFR 0.152.
 */
package org.uma.jmetal.problem.multiobjective.lz09;

import java.util.ArrayList;
import org.uma.jmetal.problem.impl.AbstractDoubleProblem;
import org.uma.jmetal.problem.multiobjective.lz09.LZ09;
import org.uma.jmetal.solution.DoubleSolution;
import org.uma.jmetal.util.JMetalException;

public class LZ09F9
extends AbstractDoubleProblem {
    private static final long serialVersionUID = 3762600989114109415L;
    private LZ09 lz09;

    public LZ09F9() throws ClassNotFoundException, JMetalException {
        this(22, 1, 22);
    }

    public LZ09F9(Integer ptype, Integer dtype, Integer ltype) throws JMetalException {
        this.setNumberOfVariables(30);
        this.setNumberOfObjectives(2);
        this.setNumberOfConstraints(0);
        this.setName("LZ09F9");
        this.lz09 = new LZ09(this.getNumberOfVariables(), this.getNumberOfObjectives(), ptype, dtype, ltype);
        ArrayList<Double> lowerLimit = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> upperLimit = new ArrayList<Double>(this.getNumberOfVariables());
        for (int i = 0; i < this.getNumberOfVariables(); ++i) {
            lowerLimit.add(0.0);
            upperLimit.add(1.0);
        }
        this.setLowerLimit(lowerLimit);
        this.setUpperLimit(upperLimit);
    }

    @Override
    public void evaluate(DoubleSolution solution) {
        int i;
        ArrayList<Double> x = new ArrayList<Double>(this.getNumberOfVariables());
        ArrayList<Double> y = new ArrayList<Double>(this.getNumberOfObjectives());
        for (i = 0; i < this.getNumberOfVariables(); ++i) {
            x.add((Double)solution.getVariableValue(i));
            y.add(0.0);
        }
        this.lz09.objective(x, y);
        for (i = 0; i < this.getNumberOfObjectives(); ++i) {
            solution.setObjective(i, (Double)y.get(i));
        }
    }
}

